package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyAudioFile invokes the ccc.ModifyAudioFile API synchronously
func (client *Client) ModifyAudioFile(request *ModifyAudioFileRequest) (response *ModifyAudioFileResponse, err error) {
	response = CreateModifyAudioFileResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyAudioFileWithChan invokes the ccc.ModifyAudioFile API asynchronously
func (client *Client) ModifyAudioFileWithChan(request *ModifyAudioFileRequest) (<-chan *ModifyAudioFileResponse, <-chan error) {
	responseChan := make(chan *ModifyAudioFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyAudioFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyAudioFileWithCallback invokes the ccc.ModifyAudioFile API asynchronously
func (client *Client) ModifyAudioFileWithCallback(request *ModifyAudioFileRequest, callback func(response *ModifyAudioFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyAudioFileResponse
		var err error
		defer close(result)
		response, err = client.ModifyAudioFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyAudioFileRequest is the request struct for api ModifyAudioFile
type ModifyAudioFileRequest struct {
	*requests.RpcRequest
	OssFileKey      string `position:"Query" name:"OssFileKey"`
	InstanceId      string `position:"Query" name:"InstanceId"`
	AudioFileName   string `position:"Query" name:"AudioFileName"`
	Name            string `position:"Query" name:"Name"`
	AudioResourceId string `position:"Query" name:"AudioResourceId"`
}

// ModifyAudioFileResponse is the response struct for api ModifyAudioFile
type ModifyAudioFileResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	Data           string `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyAudioFileRequest creates a request to invoke ModifyAudioFile API
func CreateModifyAudioFileRequest() (request *ModifyAudioFileRequest) {
	request = &ModifyAudioFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ModifyAudioFile", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyAudioFileResponse creates a response to parse from ModifyAudioFile response
func CreateModifyAudioFileResponse() (response *ModifyAudioFileResponse) {
	response = &ModifyAudioFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
