package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RedialCall invokes the ccc.RedialCall API synchronously
func (client *Client) RedialCall(request *RedialCallRequest) (response *RedialCallResponse, err error) {
	response = CreateRedialCallResponse()
	err = client.DoAction(request, response)
	return
}

// RedialCallWithChan invokes the ccc.RedialCall API asynchronously
func (client *Client) RedialCallWithChan(request *RedialCallRequest) (<-chan *RedialCallResponse, <-chan error) {
	responseChan := make(chan *RedialCallResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RedialCall(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RedialCallWithCallback invokes the ccc.RedialCall API asynchronously
func (client *Client) RedialCallWithCallback(request *RedialCallRequest, callback func(response *RedialCallResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RedialCallResponse
		var err error
		defer close(result)
		response, err = client.RedialCall(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RedialCallRequest is the request struct for api RedialCall
type RedialCallRequest struct {
	*requests.RpcRequest
	Callee         string           `position:"Query" name:"Callee"`
	UserId         string           `position:"Query" name:"UserId"`
	DeviceId       string           `position:"Query" name:"DeviceId"`
	Tags           string           `position:"Query" name:"Tags"`
	TimeoutSeconds requests.Integer `position:"Query" name:"TimeoutSeconds"`
	JobId          string           `position:"Query" name:"JobId"`
	Caller         string           `position:"Query" name:"Caller"`
	InstanceId     string           `position:"Query" name:"InstanceId"`
}

// RedialCallResponse is the response struct for api RedialCall
type RedialCallResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
	Data           Data     `json:"Data" xml:"Data"`
}

// CreateRedialCallRequest creates a request to invoke RedialCall API
func CreateRedialCallRequest() (request *RedialCallRequest) {
	request = &RedialCallRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "RedialCall", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRedialCallResponse creates a response to parse from RedialCall response
func CreateRedialCallResponse() (response *RedialCallResponse) {
	response = &RedialCallResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
