package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainSrcQpsData invokes the cdn.DescribeDomainSrcQpsData API synchronously
func (client *Client) DescribeDomainSrcQpsData(request *DescribeDomainSrcQpsDataRequest) (response *DescribeDomainSrcQpsDataResponse, err error) {
	response = CreateDescribeDomainSrcQpsDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainSrcQpsDataWithChan invokes the cdn.DescribeDomainSrcQpsData API asynchronously
func (client *Client) DescribeDomainSrcQpsDataWithChan(request *DescribeDomainSrcQpsDataRequest) (<-chan *DescribeDomainSrcQpsDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainSrcQpsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainSrcQpsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainSrcQpsDataWithCallback invokes the cdn.DescribeDomainSrcQpsData API asynchronously
func (client *Client) DescribeDomainSrcQpsDataWithCallback(request *DescribeDomainSrcQpsDataRequest, callback func(response *DescribeDomainSrcQpsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainSrcQpsDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainSrcQpsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainSrcQpsDataRequest is the request struct for api DescribeDomainSrcQpsData
type DescribeDomainSrcQpsDataRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
	EndTime    string `position:"Query" name:"EndTime"`
	Interval   string `position:"Query" name:"Interval"`
	StartTime  string `position:"Query" name:"StartTime"`
}

// DescribeDomainSrcQpsDataResponse is the response struct for api DescribeDomainSrcQpsData
type DescribeDomainSrcQpsDataResponse struct {
	*responses.BaseResponse
	EndTime               string                `json:"EndTime" xml:"EndTime"`
	StartTime             string                `json:"StartTime" xml:"StartTime"`
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	DomainName            string                `json:"DomainName" xml:"DomainName"`
	DataInterval          string                `json:"DataInterval" xml:"DataInterval"`
	SrcQpsDataPerInterval SrcQpsDataPerInterval `json:"SrcQpsDataPerInterval" xml:"SrcQpsDataPerInterval"`
}

// CreateDescribeDomainSrcQpsDataRequest creates a request to invoke DescribeDomainSrcQpsData API
func CreateDescribeDomainSrcQpsDataRequest() (request *DescribeDomainSrcQpsDataRequest) {
	request = &DescribeDomainSrcQpsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeDomainSrcQpsData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainSrcQpsDataResponse creates a response to parse from DescribeDomainSrcQpsData response
func CreateDescribeDomainSrcQpsDataResponse() (response *DescribeDomainSrcQpsDataResponse) {
	response = &DescribeDomainSrcQpsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
