package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserUsageDetailDataExportTask invokes the cdn.DescribeUserUsageDetailDataExportTask API synchronously
func (client *Client) DescribeUserUsageDetailDataExportTask(request *DescribeUserUsageDetailDataExportTaskRequest) (response *DescribeUserUsageDetailDataExportTaskResponse, err error) {
	response = CreateDescribeUserUsageDetailDataExportTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserUsageDetailDataExportTaskWithChan invokes the cdn.DescribeUserUsageDetailDataExportTask API asynchronously
func (client *Client) DescribeUserUsageDetailDataExportTaskWithChan(request *DescribeUserUsageDetailDataExportTaskRequest) (<-chan *DescribeUserUsageDetailDataExportTaskResponse, <-chan error) {
	responseChan := make(chan *DescribeUserUsageDetailDataExportTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserUsageDetailDataExportTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserUsageDetailDataExportTaskWithCallback invokes the cdn.DescribeUserUsageDetailDataExportTask API asynchronously
func (client *Client) DescribeUserUsageDetailDataExportTaskWithCallback(request *DescribeUserUsageDetailDataExportTaskRequest, callback func(response *DescribeUserUsageDetailDataExportTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserUsageDetailDataExportTaskResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserUsageDetailDataExportTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserUsageDetailDataExportTaskRequest is the request struct for api DescribeUserUsageDetailDataExportTask
type DescribeUserUsageDetailDataExportTaskRequest struct {
	*requests.RpcRequest
	PageSize   string `position:"Query" name:"PageSize"`
	PageNumber string `position:"Query" name:"PageNumber"`
}

// DescribeUserUsageDetailDataExportTaskResponse is the response struct for api DescribeUserUsageDetailDataExportTask
type DescribeUserUsageDetailDataExportTaskResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	UsageDataPerPage UsageDataPerPage `json:"UsageDataPerPage" xml:"UsageDataPerPage"`
}

// CreateDescribeUserUsageDetailDataExportTaskRequest creates a request to invoke DescribeUserUsageDetailDataExportTask API
func CreateDescribeUserUsageDetailDataExportTaskRequest() (request *DescribeUserUsageDetailDataExportTaskRequest) {
	request = &DescribeUserUsageDetailDataExportTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeUserUsageDetailDataExportTask", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeUserUsageDetailDataExportTaskResponse creates a response to parse from DescribeUserUsageDetailDataExportTask response
func CreateDescribeUserUsageDetailDataExportTaskResponse() (response *DescribeUserUsageDetailDataExportTaskResponse) {
	response = &DescribeUserUsageDetailDataExportTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
