package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckModifyConfigNeedRestart invokes the clickhouse.CheckModifyConfigNeedRestart API synchronously
func (client *Client) CheckModifyConfigNeedRestart(request *CheckModifyConfigNeedRestartRequest) (response *CheckModifyConfigNeedRestartResponse, err error) {
	response = CreateCheckModifyConfigNeedRestartResponse()
	err = client.DoAction(request, response)
	return
}

// CheckModifyConfigNeedRestartWithChan invokes the clickhouse.CheckModifyConfigNeedRestart API asynchronously
func (client *Client) CheckModifyConfigNeedRestartWithChan(request *CheckModifyConfigNeedRestartRequest) (<-chan *CheckModifyConfigNeedRestartResponse, <-chan error) {
	responseChan := make(chan *CheckModifyConfigNeedRestartResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckModifyConfigNeedRestart(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckModifyConfigNeedRestartWithCallback invokes the clickhouse.CheckModifyConfigNeedRestart API asynchronously
func (client *Client) CheckModifyConfigNeedRestartWithCallback(request *CheckModifyConfigNeedRestartRequest, callback func(response *CheckModifyConfigNeedRestartResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckModifyConfigNeedRestartResponse
		var err error
		defer close(result)
		response, err = client.CheckModifyConfigNeedRestart(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckModifyConfigNeedRestartRequest is the request struct for api CheckModifyConfigNeedRestart
type CheckModifyConfigNeedRestartRequest struct {
	*requests.RpcRequest
	DBClusterId string `position:"Query" name:"DBClusterId"`
	Config      string `position:"Query" name:"Config"`
}

// CheckModifyConfigNeedRestartResponse is the response struct for api CheckModifyConfigNeedRestart
type CheckModifyConfigNeedRestartResponse struct {
	*responses.BaseResponse
	NeedRestart bool   `json:"NeedRestart" xml:"NeedRestart"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
}

// CreateCheckModifyConfigNeedRestartRequest creates a request to invoke CheckModifyConfigNeedRestart API
func CreateCheckModifyConfigNeedRestartRequest() (request *CheckModifyConfigNeedRestartRequest) {
	request = &CheckModifyConfigNeedRestartRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "CheckModifyConfigNeedRestart", "service", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckModifyConfigNeedRestartResponse creates a response to parse from CheckModifyConfigNeedRestart response
func CreateCheckModifyConfigNeedRestartResponse() (response *CheckModifyConfigNeedRestartResponse) {
	response = &CheckModifyConfigNeedRestartResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
