package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAutomateResponseConfigFeature invokes the cloud_siem.DescribeAutomateResponseConfigFeature API synchronously
func (client *Client) DescribeAutomateResponseConfigFeature(request *DescribeAutomateResponseConfigFeatureRequest) (response *DescribeAutomateResponseConfigFeatureResponse, err error) {
	response = CreateDescribeAutomateResponseConfigFeatureResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAutomateResponseConfigFeatureWithChan invokes the cloud_siem.DescribeAutomateResponseConfigFeature API asynchronously
func (client *Client) DescribeAutomateResponseConfigFeatureWithChan(request *DescribeAutomateResponseConfigFeatureRequest) (<-chan *DescribeAutomateResponseConfigFeatureResponse, <-chan error) {
	responseChan := make(chan *DescribeAutomateResponseConfigFeatureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAutomateResponseConfigFeature(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAutomateResponseConfigFeatureWithCallback invokes the cloud_siem.DescribeAutomateResponseConfigFeature API asynchronously
func (client *Client) DescribeAutomateResponseConfigFeatureWithCallback(request *DescribeAutomateResponseConfigFeatureRequest, callback func(response *DescribeAutomateResponseConfigFeatureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAutomateResponseConfigFeatureResponse
		var err error
		defer close(result)
		response, err = client.DescribeAutomateResponseConfigFeature(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAutomateResponseConfigFeatureRequest is the request struct for api DescribeAutomateResponseConfigFeature
type DescribeAutomateResponseConfigFeatureRequest struct {
	*requests.RpcRequest
	AutoResponseType string `position:"Body" name:"AutoResponseType"`
}

// DescribeAutomateResponseConfigFeatureResponse is the response struct for api DescribeAutomateResponseConfigFeature
type DescribeAutomateResponseConfigFeatureResponse struct {
	*responses.BaseResponse
	Success   bool       `json:"Success" xml:"Success"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeAutomateResponseConfigFeatureRequest creates a request to invoke DescribeAutomateResponseConfigFeature API
func CreateDescribeAutomateResponseConfigFeatureRequest() (request *DescribeAutomateResponseConfigFeatureRequest) {
	request = &DescribeAutomateResponseConfigFeatureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeAutomateResponseConfigFeature", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAutomateResponseConfigFeatureResponse creates a response to parse from DescribeAutomateResponseConfigFeature response
func CreateDescribeAutomateResponseConfigFeatureResponse() (response *DescribeAutomateResponseConfigFeatureResponse) {
	response = &DescribeAutomateResponseConfigFeatureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
