package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOperators invokes the cloud_siem.DescribeOperators API synchronously
func (client *Client) DescribeOperators(request *DescribeOperatorsRequest) (response *DescribeOperatorsResponse, err error) {
	response = CreateDescribeOperatorsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOperatorsWithChan invokes the cloud_siem.DescribeOperators API asynchronously
func (client *Client) DescribeOperatorsWithChan(request *DescribeOperatorsRequest) (<-chan *DescribeOperatorsResponse, <-chan error) {
	responseChan := make(chan *DescribeOperatorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOperators(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOperatorsWithCallback invokes the cloud_siem.DescribeOperators API asynchronously
func (client *Client) DescribeOperatorsWithCallback(request *DescribeOperatorsRequest, callback func(response *DescribeOperatorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOperatorsResponse
		var err error
		defer close(result)
		response, err = client.DescribeOperators(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOperatorsRequest is the request struct for api DescribeOperators
type DescribeOperatorsRequest struct {
	*requests.RpcRequest
	SceneType string `position:"Body" name:"SceneType"`
}

// DescribeOperatorsResponse is the response struct for api DescribeOperators
type DescribeOperatorsResponse struct {
	*responses.BaseResponse
	Success   bool       `json:"Success" xml:"Success"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeOperatorsRequest creates a request to invoke DescribeOperators API
func CreateDescribeOperatorsRequest() (request *DescribeOperatorsRequest) {
	request = &DescribeOperatorsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeOperators", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeOperatorsResponse creates a response to parse from DescribeOperators response
func CreateDescribeOperatorsResponse() (response *DescribeOperatorsResponse) {
	response = &DescribeOperatorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
