package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCustomizeRuleTestResult invokes the cloud_siem.ListCustomizeRuleTestResult API synchronously
func (client *Client) ListCustomizeRuleTestResult(request *ListCustomizeRuleTestResultRequest) (response *ListCustomizeRuleTestResultResponse, err error) {
	response = CreateListCustomizeRuleTestResultResponse()
	err = client.DoAction(request, response)
	return
}

// ListCustomizeRuleTestResultWithChan invokes the cloud_siem.ListCustomizeRuleTestResult API asynchronously
func (client *Client) ListCustomizeRuleTestResultWithChan(request *ListCustomizeRuleTestResultRequest) (<-chan *ListCustomizeRuleTestResultResponse, <-chan error) {
	responseChan := make(chan *ListCustomizeRuleTestResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCustomizeRuleTestResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCustomizeRuleTestResultWithCallback invokes the cloud_siem.ListCustomizeRuleTestResult API asynchronously
func (client *Client) ListCustomizeRuleTestResultWithCallback(request *ListCustomizeRuleTestResultRequest, callback func(response *ListCustomizeRuleTestResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCustomizeRuleTestResultResponse
		var err error
		defer close(result)
		response, err = client.ListCustomizeRuleTestResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCustomizeRuleTestResultRequest is the request struct for api ListCustomizeRuleTestResult
type ListCustomizeRuleTestResultRequest struct {
	*requests.RpcRequest
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	Id          requests.Integer `position:"Body" name:"Id"`
	CurrentPage requests.Integer `position:"Body" name:"CurrentPage"`
}

// ListCustomizeRuleTestResultResponse is the response struct for api ListCustomizeRuleTestResult
type ListCustomizeRuleTestResultResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListCustomizeRuleTestResultRequest creates a request to invoke ListCustomizeRuleTestResult API
func CreateListCustomizeRuleTestResultRequest() (request *ListCustomizeRuleTestResultRequest) {
	request = &ListCustomizeRuleTestResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "ListCustomizeRuleTestResult", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListCustomizeRuleTestResultResponse creates a response to parse from ListCustomizeRuleTestResult response
func CreateListCustomizeRuleTestResultResponse() (response *ListCustomizeRuleTestResultResponse) {
	response = &ListCustomizeRuleTestResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
