package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveApiProductsAuthorities invokes the cloudapi.RemoveApiProductsAuthorities API synchronously
func (client *Client) RemoveApiProductsAuthorities(request *RemoveApiProductsAuthoritiesRequest) (response *RemoveApiProductsAuthoritiesResponse, err error) {
	response = CreateRemoveApiProductsAuthoritiesResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveApiProductsAuthoritiesWithChan invokes the cloudapi.RemoveApiProductsAuthorities API asynchronously
func (client *Client) RemoveApiProductsAuthoritiesWithChan(request *RemoveApiProductsAuthoritiesRequest) (<-chan *RemoveApiProductsAuthoritiesResponse, <-chan error) {
	responseChan := make(chan *RemoveApiProductsAuthoritiesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveApiProductsAuthorities(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveApiProductsAuthoritiesWithCallback invokes the cloudapi.RemoveApiProductsAuthorities API asynchronously
func (client *Client) RemoveApiProductsAuthoritiesWithCallback(request *RemoveApiProductsAuthoritiesRequest, callback func(response *RemoveApiProductsAuthoritiesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveApiProductsAuthoritiesResponse
		var err error
		defer close(result)
		response, err = client.RemoveApiProductsAuthorities(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveApiProductsAuthoritiesRequest is the request struct for api RemoveApiProductsAuthorities
type RemoveApiProductsAuthoritiesRequest struct {
	*requests.RpcRequest
	ApiProductIds *[]string        `position:"Query" name:"ApiProductIds"  type:"Repeated"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	AppId         requests.Integer `position:"Query" name:"AppId"`
}

// RemoveApiProductsAuthoritiesResponse is the response struct for api RemoveApiProductsAuthorities
type RemoveApiProductsAuthoritiesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveApiProductsAuthoritiesRequest creates a request to invoke RemoveApiProductsAuthorities API
func CreateRemoveApiProductsAuthoritiesRequest() (request *RemoveApiProductsAuthoritiesRequest) {
	request = &RemoveApiProductsAuthoritiesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "RemoveApiProductsAuthorities", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveApiProductsAuthoritiesResponse creates a response to parse from RemoveApiProductsAuthorities response
func CreateRemoveApiProductsAuthoritiesResponse() (response *RemoveApiProductsAuthoritiesResponse) {
	response = &RemoveApiProductsAuthoritiesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
