package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetGroupAuthAppCode invokes the cloudapi.SetGroupAuthAppCode API synchronously
func (client *Client) SetGroupAuthAppCode(request *SetGroupAuthAppCodeRequest) (response *SetGroupAuthAppCodeResponse, err error) {
	response = CreateSetGroupAuthAppCodeResponse()
	err = client.DoAction(request, response)
	return
}

// SetGroupAuthAppCodeWithChan invokes the cloudapi.SetGroupAuthAppCode API asynchronously
func (client *Client) SetGroupAuthAppCodeWithChan(request *SetGroupAuthAppCodeRequest) (<-chan *SetGroupAuthAppCodeResponse, <-chan error) {
	responseChan := make(chan *SetGroupAuthAppCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetGroupAuthAppCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetGroupAuthAppCodeWithCallback invokes the cloudapi.SetGroupAuthAppCode API asynchronously
func (client *Client) SetGroupAuthAppCodeWithCallback(request *SetGroupAuthAppCodeRequest, callback func(response *SetGroupAuthAppCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetGroupAuthAppCodeResponse
		var err error
		defer close(result)
		response, err = client.SetGroupAuthAppCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetGroupAuthAppCodeRequest is the request struct for api SetGroupAuthAppCode
type SetGroupAuthAppCodeRequest struct {
	*requests.RpcRequest
	GroupId       string `position:"Query" name:"GroupId"`
	AuthAppCode   string `position:"Query" name:"AuthAppCode"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// SetGroupAuthAppCodeResponse is the response struct for api SetGroupAuthAppCode
type SetGroupAuthAppCodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetGroupAuthAppCodeRequest creates a request to invoke SetGroupAuthAppCode API
func CreateSetGroupAuthAppCodeRequest() (request *SetGroupAuthAppCodeRequest) {
	request = &SetGroupAuthAppCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "SetGroupAuthAppCode", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetGroupAuthAppCodeResponse creates a response to parse from SetGroupAuthAppCode response
func CreateSetGroupAuthAppCodeResponse() (response *SetGroupAuthAppCodeResponse) {
	response = &SetGroupAuthAppCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
