package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMediasWithPublic invokes the cloudcallcenter.ListMediasWithPublic API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listmediaswithpublic.html
func (client *Client) ListMediasWithPublic(request *ListMediasWithPublicRequest) (response *ListMediasWithPublicResponse, err error) {
	response = CreateListMediasWithPublicResponse()
	err = client.DoAction(request, response)
	return
}

// ListMediasWithPublicWithChan invokes the cloudcallcenter.ListMediasWithPublic API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listmediaswithpublic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListMediasWithPublicWithChan(request *ListMediasWithPublicRequest) (<-chan *ListMediasWithPublicResponse, <-chan error) {
	responseChan := make(chan *ListMediasWithPublicResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMediasWithPublic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMediasWithPublicWithCallback invokes the cloudcallcenter.ListMediasWithPublic API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listmediaswithpublic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListMediasWithPublicWithCallback(request *ListMediasWithPublicRequest, callback func(response *ListMediasWithPublicResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMediasWithPublicResponse
		var err error
		defer close(result)
		response, err = client.ListMediasWithPublic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMediasWithPublicRequest is the request struct for api ListMediasWithPublic
type ListMediasWithPublicRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	NamePrefix string           `position:"Query" name:"NamePrefix"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListMediasWithPublicResponse is the response struct for api ListMediasWithPublic
type ListMediasWithPublicResponse struct {
	*responses.BaseResponse
	RequestId      string       `json:"RequestId" xml:"RequestId"`
	Success        bool         `json:"Success" xml:"Success"`
	Code           string       `json:"Code" xml:"Code"`
	Message        string       `json:"Message" xml:"Message"`
	HttpStatusCode int          `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Medias         Medias       `json:"Medias" xml:"Medias"`
	PublicMedias   PublicMedias `json:"PublicMedias" xml:"PublicMedias"`
}

// CreateListMediasWithPublicRequest creates a request to invoke ListMediasWithPublic API
func CreateListMediasWithPublicRequest() (request *ListMediasWithPublicRequest) {
	request = &ListMediasWithPublicRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListMediasWithPublic", "", "")
	request.Method = requests.POST
	return
}

// CreateListMediasWithPublicResponse creates a response to parse from ListMediasWithPublic response
func CreateListMediasWithPublicResponse() (response *ListMediasWithPublicResponse) {
	response = &ListMediasWithPublicResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
