package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindDeviceLayout invokes the cloudesl.BindDeviceLayout API synchronously
func (client *Client) BindDeviceLayout(request *BindDeviceLayoutRequest) (response *BindDeviceLayoutResponse, err error) {
	response = CreateBindDeviceLayoutResponse()
	err = client.DoAction(request, response)
	return
}

// BindDeviceLayoutWithChan invokes the cloudesl.BindDeviceLayout API asynchronously
func (client *Client) BindDeviceLayoutWithChan(request *BindDeviceLayoutRequest) (<-chan *BindDeviceLayoutResponse, <-chan error) {
	responseChan := make(chan *BindDeviceLayoutResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindDeviceLayout(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindDeviceLayoutWithCallback invokes the cloudesl.BindDeviceLayout API asynchronously
func (client *Client) BindDeviceLayoutWithCallback(request *BindDeviceLayoutRequest, callback func(response *BindDeviceLayoutResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindDeviceLayoutResponse
		var err error
		defer close(result)
		response, err = client.BindDeviceLayout(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindDeviceLayoutRequest is the request struct for api BindDeviceLayout
type BindDeviceLayoutRequest struct {
	*requests.RpcRequest
	StoreId    string `position:"Body" name:"StoreId"`
	LayoutId   string `position:"Body" name:"LayoutId"`
	EslBarCode string `position:"Body" name:"EslBarCode"`
}

// BindDeviceLayoutResponse is the response struct for api BindDeviceLayout
type BindDeviceLayoutResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string `json:"Code" xml:"Code"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
}

// CreateBindDeviceLayoutRequest creates a request to invoke BindDeviceLayout API
func CreateBindDeviceLayoutRequest() (request *BindDeviceLayoutRequest) {
	request = &BindDeviceLayoutRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "BindDeviceLayout", "", "")
	request.Method = requests.POST
	return
}

// CreateBindDeviceLayoutResponse creates a response to parse from BindDeviceLayout response
func CreateBindDeviceLayoutResponse() (response *BindDeviceLayoutResponse) {
	response = &BindDeviceLayoutResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
