package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CopyLayout invokes the cloudesl.CopyLayout API synchronously
func (client *Client) CopyLayout(request *CopyLayoutRequest) (response *CopyLayoutResponse, err error) {
	response = CreateCopyLayoutResponse()
	err = client.DoAction(request, response)
	return
}

// CopyLayoutWithChan invokes the cloudesl.CopyLayout API asynchronously
func (client *Client) CopyLayoutWithChan(request *CopyLayoutRequest) (<-chan *CopyLayoutResponse, <-chan error) {
	responseChan := make(chan *CopyLayoutResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CopyLayout(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CopyLayoutWithCallback invokes the cloudesl.CopyLayout API asynchronously
func (client *Client) CopyLayoutWithCallback(request *CopyLayoutRequest, callback func(response *CopyLayoutResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CopyLayoutResponse
		var err error
		defer close(result)
		response, err = client.CopyLayout(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CopyLayoutRequest is the request struct for api CopyLayout
type CopyLayoutRequest struct {
	*requests.RpcRequest
	LayoutId        requests.Integer `position:"Body" name:"LayoutId"`
	TemplateVersion string           `position:"Body" name:"TemplateVersion"`
	EslModelId      string           `position:"Body" name:"EslModelId"`
}

// CopyLayoutResponse is the response struct for api CopyLayout
type CopyLayoutResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string `json:"Code" xml:"Code"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
}

// CreateCopyLayoutRequest creates a request to invoke CopyLayout API
func CreateCopyLayoutRequest() (request *CopyLayoutRequest) {
	request = &CopyLayoutRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "CopyLayout", "", "")
	request.Method = requests.POST
	return
}

// CreateCopyLayoutResponse creates a response to parse from CopyLayout response
func CreateCopyLayoutResponse() (response *CopyLayoutResponse) {
	response = &CopyLayoutResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
