package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTemplateGroup invokes the cloudesl.DeleteTemplateGroup API synchronously
func (client *Client) DeleteTemplateGroup(request *DeleteTemplateGroupRequest) (response *DeleteTemplateGroupResponse, err error) {
	response = CreateDeleteTemplateGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTemplateGroupWithChan invokes the cloudesl.DeleteTemplateGroup API asynchronously
func (client *Client) DeleteTemplateGroupWithChan(request *DeleteTemplateGroupRequest) (<-chan *DeleteTemplateGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteTemplateGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTemplateGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTemplateGroupWithCallback invokes the cloudesl.DeleteTemplateGroup API asynchronously
func (client *Client) DeleteTemplateGroupWithCallback(request *DeleteTemplateGroupRequest, callback func(response *DeleteTemplateGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTemplateGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteTemplateGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTemplateGroupRequest is the request struct for api DeleteTemplateGroup
type DeleteTemplateGroupRequest struct {
	*requests.RpcRequest
	GroupId string `position:"Body" name:"GroupId"`
}

// DeleteTemplateGroupResponse is the response struct for api DeleteTemplateGroup
type DeleteTemplateGroupResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string `json:"Code" xml:"Code"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
}

// CreateDeleteTemplateGroupRequest creates a request to invoke DeleteTemplateGroup API
func CreateDeleteTemplateGroupRequest() (request *DeleteTemplateGroupRequest) {
	request = &DeleteTemplateGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "DeleteTemplateGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteTemplateGroupResponse creates a response to parse from DeleteTemplateGroup response
func CreateDeleteTemplateGroupResponse() (response *DeleteTemplateGroupResponse) {
	response = &DeleteTemplateGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
