package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAvailableEslModels invokes the cloudesl.DescribeAvailableEslModels API synchronously
func (client *Client) DescribeAvailableEslModels(request *DescribeAvailableEslModelsRequest) (response *DescribeAvailableEslModelsResponse, err error) {
	response = CreateDescribeAvailableEslModelsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAvailableEslModelsWithChan invokes the cloudesl.DescribeAvailableEslModels API asynchronously
func (client *Client) DescribeAvailableEslModelsWithChan(request *DescribeAvailableEslModelsRequest) (<-chan *DescribeAvailableEslModelsResponse, <-chan error) {
	responseChan := make(chan *DescribeAvailableEslModelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAvailableEslModels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAvailableEslModelsWithCallback invokes the cloudesl.DescribeAvailableEslModels API asynchronously
func (client *Client) DescribeAvailableEslModelsWithCallback(request *DescribeAvailableEslModelsRequest, callback func(response *DescribeAvailableEslModelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAvailableEslModelsResponse
		var err error
		defer close(result)
		response, err = client.DescribeAvailableEslModels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAvailableEslModelsRequest is the request struct for api DescribeAvailableEslModels
type DescribeAvailableEslModelsRequest struct {
	*requests.RpcRequest
	ModelId    string           `position:"Body" name:"ModelId"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	Name       string           `position:"Body" name:"Name"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
}

// DescribeAvailableEslModelsResponse is the response struct for api DescribeAvailableEslModels
type DescribeAvailableEslModelsResponse struct {
	*responses.BaseResponse
	TotalCount     int              `json:"TotalCount" xml:"TotalCount"`
	PageSize       int              `json:"PageSize" xml:"PageSize"`
	PageNumber     int              `json:"PageNumber" xml:"PageNumber"`
	RequestId      string           `json:"RequestId" xml:"RequestId"`
	Success        bool             `json:"Success" xml:"Success"`
	Message        string           `json:"Message" xml:"Message"`
	ErrorCode      string           `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string           `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string           `json:"Code" xml:"Code"`
	DynamicCode    string           `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string           `json:"DynamicMessage" xml:"DynamicMessage"`
	EslModels      []SelectItemInfo `json:"EslModels" xml:"EslModels"`
}

// CreateDescribeAvailableEslModelsRequest creates a request to invoke DescribeAvailableEslModels API
func CreateDescribeAvailableEslModelsRequest() (request *DescribeAvailableEslModelsRequest) {
	request = &DescribeAvailableEslModelsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "DescribeAvailableEslModels", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeAvailableEslModelsResponse creates a response to parse from DescribeAvailableEslModels response
func CreateDescribeAvailableEslModelsResponse() (response *DescribeAvailableEslModelsResponse) {
	response = &DescribeAvailableEslModelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
