package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInternetTrafficTrend invokes the cloudfw.DescribeInternetTrafficTrend API synchronously
func (client *Client) DescribeInternetTrafficTrend(request *DescribeInternetTrafficTrendRequest) (response *DescribeInternetTrafficTrendResponse, err error) {
	response = CreateDescribeInternetTrafficTrendResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInternetTrafficTrendWithChan invokes the cloudfw.DescribeInternetTrafficTrend API asynchronously
func (client *Client) DescribeInternetTrafficTrendWithChan(request *DescribeInternetTrafficTrendRequest) (<-chan *DescribeInternetTrafficTrendResponse, <-chan error) {
	responseChan := make(chan *DescribeInternetTrafficTrendResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInternetTrafficTrend(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInternetTrafficTrendWithCallback invokes the cloudfw.DescribeInternetTrafficTrend API asynchronously
func (client *Client) DescribeInternetTrafficTrendWithCallback(request *DescribeInternetTrafficTrendRequest, callback func(response *DescribeInternetTrafficTrendResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInternetTrafficTrendResponse
		var err error
		defer close(result)
		response, err = client.DescribeInternetTrafficTrend(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInternetTrafficTrendRequest is the request struct for api DescribeInternetTrafficTrend
type DescribeInternetTrafficTrendRequest struct {
	*requests.RpcRequest
	StartTime    string `position:"Query" name:"StartTime"`
	SourceCode   string `position:"Query" name:"SourceCode"`
	SourceIp     string `position:"Query" name:"SourceIp"`
	Lang         string `position:"Query" name:"Lang"`
	Direction    string `position:"Query" name:"Direction"`
	SrcPrivateIP string `position:"Query" name:"SrcPrivateIP"`
	EndTime      string `position:"Query" name:"EndTime"`
	SrcPublicIP  string `position:"Query" name:"SrcPublicIP"`
	TrafficType  string `position:"Query" name:"TrafficType"`
}

// DescribeInternetTrafficTrendResponse is the response struct for api DescribeInternetTrafficTrend
type DescribeInternetTrafficTrendResponse struct {
	*responses.BaseResponse
	MaxTotalBps      int64  `json:"MaxTotalBps" xml:"MaxTotalBps"`
	MaxBandwidthTime int64  `json:"MaxBandwidthTime" xml:"MaxBandwidthTime"`
	AvgInBps         int64  `json:"AvgInBps" xml:"AvgInBps"`
	RequestId        string `json:"RequestId" xml:"RequestId"`
	MaxInBps         int64  `json:"MaxInBps" xml:"MaxInBps"`
	MaxOutBps        int64  `json:"MaxOutBps" xml:"MaxOutBps"`
	AvgSession       int64  `json:"AvgSession" xml:"AvgSession"`
	MaxSession       int64  `json:"MaxSession" xml:"MaxSession"`
	AvgTotalBps      int64  `json:"AvgTotalBps" xml:"AvgTotalBps"`
	AvgOutBps        int64  `json:"AvgOutBps" xml:"AvgOutBps"`
	TotalInBytes     int64  `json:"TotalInBytes" xml:"TotalInBytes"`
	TotalOutBytes    int64  `json:"TotalOutBytes" xml:"TotalOutBytes"`
	TotalBytes       int64  `json:"TotalBytes" xml:"TotalBytes"`
	TotalSession     int64  `json:"TotalSession" xml:"TotalSession"`
	DataList         []Data `json:"DataList" xml:"DataList"`
}

// CreateDescribeInternetTrafficTrendRequest creates a request to invoke DescribeInternetTrafficTrend API
func CreateDescribeInternetTrafficTrendRequest() (request *DescribeInternetTrafficTrendRequest) {
	request = &DescribeInternetTrafficTrendRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeInternetTrafficTrend", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInternetTrafficTrendResponse creates a response to parse from DescribeInternetTrafficTrend response
func CreateDescribeInternetTrafficTrendResponse() (response *DescribeInternetTrafficTrendResponse) {
	response = &DescribeInternetTrafficTrendResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
