package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInvadeEventList invokes the cloudfw.DescribeInvadeEventList API synchronously
func (client *Client) DescribeInvadeEventList(request *DescribeInvadeEventListRequest) (response *DescribeInvadeEventListResponse, err error) {
	response = CreateDescribeInvadeEventListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInvadeEventListWithChan invokes the cloudfw.DescribeInvadeEventList API asynchronously
func (client *Client) DescribeInvadeEventListWithChan(request *DescribeInvadeEventListRequest) (<-chan *DescribeInvadeEventListResponse, <-chan error) {
	responseChan := make(chan *DescribeInvadeEventListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInvadeEventList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInvadeEventListWithCallback invokes the cloudfw.DescribeInvadeEventList API asynchronously
func (client *Client) DescribeInvadeEventListWithCallback(request *DescribeInvadeEventListRequest, callback func(response *DescribeInvadeEventListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInvadeEventListResponse
		var err error
		defer close(result)
		response, err = client.DescribeInvadeEventList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInvadeEventListRequest is the request struct for api DescribeInvadeEventList
type DescribeInvadeEventListRequest struct {
	*requests.RpcRequest
	ProcessStatus      string           `position:"Query" name:"ProcessStatus"`
	ProcessStatusList  *[]string        `position:"Query" name:"ProcessStatusList"  type:"Repeated"`
	StartTime          string           `position:"Query" name:"StartTime"`
	EventName          string           `position:"Query" name:"EventName"`
	SourceIp           string           `position:"Query" name:"SourceIp"`
	AssetsInstanceId   string           `position:"Query" name:"AssetsInstanceId"`
	EventKey           string           `position:"Query" name:"EventKey"`
	PageSize           string           `position:"Query" name:"PageSize"`
	Lang               string           `position:"Query" name:"Lang"`
	IsIgnore           string           `position:"Query" name:"IsIgnore"`
	EndTime            string           `position:"Query" name:"EndTime"`
	CurrentPage        string           `position:"Query" name:"CurrentPage"`
	AssetsIP           string           `position:"Query" name:"AssetsIP"`
	RiskLevel          *[]string        `position:"Query" name:"RiskLevel"  type:"Repeated"`
	MemberUid          requests.Integer `position:"Query" name:"MemberUid"`
	EventUuid          string           `position:"Query" name:"EventUuid"`
	AssetsInstanceName string           `position:"Query" name:"AssetsInstanceName"`
}

// DescribeInvadeEventListResponse is the response struct for api DescribeInvadeEventList
type DescribeInvadeEventListResponse struct {
	*responses.BaseResponse
	LowLevelPercent    int                             `json:"LowLevelPercent" xml:"LowLevelPercent"`
	RequestId          string                          `json:"RequestId" xml:"RequestId"`
	MiddleLevelPercent int                             `json:"MiddleLevelPercent" xml:"MiddleLevelPercent"`
	HighLevelPercent   int                             `json:"HighLevelPercent" xml:"HighLevelPercent"`
	PageInfo           PageInfo                        `json:"PageInfo" xml:"PageInfo"`
	EventList          []DataInDescribeInvadeEventList `json:"EventList" xml:"EventList"`
}

// CreateDescribeInvadeEventListRequest creates a request to invoke DescribeInvadeEventList API
func CreateDescribeInvadeEventListRequest() (request *DescribeInvadeEventListRequest) {
	request = &DescribeInvadeEventListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeInvadeEventList", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInvadeEventListResponse creates a response to parse from DescribeInvadeEventList response
func CreateDescribeInvadeEventListResponse() (response *DescribeInvadeEventListResponse) {
	response = &DescribeInvadeEventListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
