package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVpcFirewallDefaultIPSConfig invokes the cloudfw.ModifyVpcFirewallDefaultIPSConfig API synchronously
func (client *Client) ModifyVpcFirewallDefaultIPSConfig(request *ModifyVpcFirewallDefaultIPSConfigRequest) (response *ModifyVpcFirewallDefaultIPSConfigResponse, err error) {
	response = CreateModifyVpcFirewallDefaultIPSConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVpcFirewallDefaultIPSConfigWithChan invokes the cloudfw.ModifyVpcFirewallDefaultIPSConfig API asynchronously
func (client *Client) ModifyVpcFirewallDefaultIPSConfigWithChan(request *ModifyVpcFirewallDefaultIPSConfigRequest) (<-chan *ModifyVpcFirewallDefaultIPSConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyVpcFirewallDefaultIPSConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVpcFirewallDefaultIPSConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVpcFirewallDefaultIPSConfigWithCallback invokes the cloudfw.ModifyVpcFirewallDefaultIPSConfig API asynchronously
func (client *Client) ModifyVpcFirewallDefaultIPSConfigWithCallback(request *ModifyVpcFirewallDefaultIPSConfigRequest, callback func(response *ModifyVpcFirewallDefaultIPSConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVpcFirewallDefaultIPSConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyVpcFirewallDefaultIPSConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVpcFirewallDefaultIPSConfigRequest is the request struct for api ModifyVpcFirewallDefaultIPSConfig
type ModifyVpcFirewallDefaultIPSConfigRequest struct {
	*requests.RpcRequest
	RunMode        string `position:"Query" name:"RunMode"`
	BasicRules     string `position:"Query" name:"BasicRules"`
	SourceIp       string `position:"Query" name:"SourceIp"`
	Lang           string `position:"Query" name:"Lang"`
	VpcFirewallId  string `position:"Query" name:"VpcFirewallId"`
	EnableAllPatch string `position:"Query" name:"EnableAllPatch"`
	MemberUid      string `position:"Query" name:"MemberUid"`
}

// ModifyVpcFirewallDefaultIPSConfigResponse is the response struct for api ModifyVpcFirewallDefaultIPSConfig
type ModifyVpcFirewallDefaultIPSConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVpcFirewallDefaultIPSConfigRequest creates a request to invoke ModifyVpcFirewallDefaultIPSConfig API
func CreateModifyVpcFirewallDefaultIPSConfigRequest() (request *ModifyVpcFirewallDefaultIPSConfigRequest) {
	request = &ModifyVpcFirewallDefaultIPSConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "ModifyVpcFirewallDefaultIPSConfig", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyVpcFirewallDefaultIPSConfigResponse creates a response to parse from ModifyVpcFirewallDefaultIPSConfig response
func CreateModifyVpcFirewallDefaultIPSConfigResponse() (response *ModifyVpcFirewallDefaultIPSConfigResponse) {
	response = &ModifyVpcFirewallDefaultIPSConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
