package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReportDay invokes the cloudwf.ReportDay API synchronously
// api document: https://help.aliyun.com/api/cloudwf/reportday.html
func (client *Client) ReportDay(request *ReportDayRequest) (response *ReportDayResponse, err error) {
	response = CreateReportDayResponse()
	err = client.DoAction(request, response)
	return
}

// ReportDayWithChan invokes the cloudwf.ReportDay API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/reportday.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReportDayWithChan(request *ReportDayRequest) (<-chan *ReportDayResponse, <-chan error) {
	responseChan := make(chan *ReportDayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReportDay(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReportDayWithCallback invokes the cloudwf.ReportDay API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/reportday.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReportDayWithCallback(request *ReportDayRequest, callback func(response *ReportDayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReportDayResponse
		var err error
		defer close(result)
		response, err = client.ReportDay(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReportDayRequest is the request struct for api ReportDay
type ReportDayRequest struct {
	*requests.RpcRequest
	BeginDate string           `position:"Query" name:"BeginDate"`
	EndDate   string           `position:"Query" name:"EndDate"`
	Agsid     requests.Integer `position:"Query" name:"Agsid"`
}

// ReportDayResponse is the response struct for api ReportDay
type ReportDayResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateReportDayRequest creates a request to invoke ReportDay API
func CreateReportDayRequest() (request *ReportDayRequest) {
	request = &ReportDayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ReportDay", "cloudwf", "openAPI")
	return
}

// CreateReportDayResponse creates a response to parse from ReportDay response
func CreateReportDayResponse() (response *ReportDayResponse) {
	response = &ReportDayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
