package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyHybridMonitorSLSGroup invokes the cms.ModifyHybridMonitorSLSGroup API synchronously
func (client *Client) ModifyHybridMonitorSLSGroup(request *ModifyHybridMonitorSLSGroupRequest) (response *ModifyHybridMonitorSLSGroupResponse, err error) {
	response = CreateModifyHybridMonitorSLSGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyHybridMonitorSLSGroupWithChan invokes the cms.ModifyHybridMonitorSLSGroup API asynchronously
func (client *Client) ModifyHybridMonitorSLSGroupWithChan(request *ModifyHybridMonitorSLSGroupRequest) (<-chan *ModifyHybridMonitorSLSGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyHybridMonitorSLSGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyHybridMonitorSLSGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyHybridMonitorSLSGroupWithCallback invokes the cms.ModifyHybridMonitorSLSGroup API asynchronously
func (client *Client) ModifyHybridMonitorSLSGroupWithCallback(request *ModifyHybridMonitorSLSGroupRequest, callback func(response *ModifyHybridMonitorSLSGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyHybridMonitorSLSGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyHybridMonitorSLSGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyHybridMonitorSLSGroupRequest is the request struct for api ModifyHybridMonitorSLSGroup
type ModifyHybridMonitorSLSGroupRequest struct {
	*requests.RpcRequest
	SLSGroupDescription string                                       `position:"Query" name:"SLSGroupDescription"`
	SLSGroupConfig      *[]ModifyHybridMonitorSLSGroupSLSGroupConfig `position:"Query" name:"SLSGroupConfig"  type:"Repeated"`
	SLSGroupName        string                                       `position:"Query" name:"SLSGroupName"`
}

// ModifyHybridMonitorSLSGroupSLSGroupConfig is a repeated param struct in ModifyHybridMonitorSLSGroupRequest
type ModifyHybridMonitorSLSGroupSLSGroupConfig struct {
	SLSLogstore string `name:"SLSLogstore"`
	SLSUserId   string `name:"SLSUserId"`
	SLSProject  string `name:"SLSProject"`
	SLSRegion   string `name:"SLSRegion"`
}

// ModifyHybridMonitorSLSGroupResponse is the response struct for api ModifyHybridMonitorSLSGroup
type ModifyHybridMonitorSLSGroupResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateModifyHybridMonitorSLSGroupRequest creates a request to invoke ModifyHybridMonitorSLSGroup API
func CreateModifyHybridMonitorSLSGroupRequest() (request *ModifyHybridMonitorSLSGroupRequest) {
	request = &ModifyHybridMonitorSLSGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "ModifyHybridMonitorSLSGroup", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyHybridMonitorSLSGroupResponse creates a response to parse from ModifyHybridMonitorSLSGroup response
func CreateModifyHybridMonitorSLSGroupResponse() (response *ModifyHybridMonitorSLSGroupResponse) {
	response = &ModifyHybridMonitorSLSGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
