package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyMetricRuleBlackList invokes the cms.ModifyMetricRuleBlackList API synchronously
func (client *Client) ModifyMetricRuleBlackList(request *ModifyMetricRuleBlackListRequest) (response *ModifyMetricRuleBlackListResponse, err error) {
	response = CreateModifyMetricRuleBlackListResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyMetricRuleBlackListWithChan invokes the cms.ModifyMetricRuleBlackList API asynchronously
func (client *Client) ModifyMetricRuleBlackListWithChan(request *ModifyMetricRuleBlackListRequest) (<-chan *ModifyMetricRuleBlackListResponse, <-chan error) {
	responseChan := make(chan *ModifyMetricRuleBlackListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyMetricRuleBlackList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyMetricRuleBlackListWithCallback invokes the cms.ModifyMetricRuleBlackList API asynchronously
func (client *Client) ModifyMetricRuleBlackListWithCallback(request *ModifyMetricRuleBlackListRequest, callback func(response *ModifyMetricRuleBlackListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyMetricRuleBlackListResponse
		var err error
		defer close(result)
		response, err = client.ModifyMetricRuleBlackList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyMetricRuleBlackListRequest is the request struct for api ModifyMetricRuleBlackList
type ModifyMetricRuleBlackListRequest struct {
	*requests.RpcRequest
	ScopeType       string                              `position:"Query" name:"ScopeType"`
	Instances       *[]string                           `position:"Query" name:"Instances"  type:"Repeated"`
	EnableEndTime   string                              `position:"Query" name:"EnableEndTime"`
	ScopeValue      string                              `position:"Query" name:"ScopeValue"`
	EnableStartTime string                              `position:"Query" name:"EnableStartTime"`
	EffectiveTime   string                              `position:"Query" name:"EffectiveTime"`
	Id              string                              `position:"Query" name:"Id"`
	Name            string                              `position:"Query" name:"Name"`
	Namespace       string                              `position:"Query" name:"Namespace"`
	Metrics         *[]ModifyMetricRuleBlackListMetrics `position:"Query" name:"Metrics"  type:"Repeated"`
	Category        string                              `position:"Query" name:"Category"`
}

// ModifyMetricRuleBlackListMetrics is a repeated param struct in ModifyMetricRuleBlackListRequest
type ModifyMetricRuleBlackListMetrics struct {
	Resource   string `name:"Resource"`
	MetricName string `name:"MetricName"`
}

// ModifyMetricRuleBlackListResponse is the response struct for api ModifyMetricRuleBlackList
type ModifyMetricRuleBlackListResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Count     string `json:"Count" xml:"Count"`
}

// CreateModifyMetricRuleBlackListRequest creates a request to invoke ModifyMetricRuleBlackList API
func CreateModifyMetricRuleBlackListRequest() (request *ModifyMetricRuleBlackListRequest) {
	request = &ModifyMetricRuleBlackListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "ModifyMetricRuleBlackList", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyMetricRuleBlackListResponse creates a response to parse from ModifyMetricRuleBlackList response
func CreateModifyMetricRuleBlackListResponse() (response *ModifyMetricRuleBlackListResponse) {
	response = &ModifyMetricRuleBlackListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
