package computenest

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListServiceInstanceResources invokes the computenest.ListServiceInstanceResources API synchronously
func (client *Client) ListServiceInstanceResources(request *ListServiceInstanceResourcesRequest) (response *ListServiceInstanceResourcesResponse, err error) {
	response = CreateListServiceInstanceResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// ListServiceInstanceResourcesWithChan invokes the computenest.ListServiceInstanceResources API asynchronously
func (client *Client) ListServiceInstanceResourcesWithChan(request *ListServiceInstanceResourcesRequest) (<-chan *ListServiceInstanceResourcesResponse, <-chan error) {
	responseChan := make(chan *ListServiceInstanceResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListServiceInstanceResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListServiceInstanceResourcesWithCallback invokes the computenest.ListServiceInstanceResources API asynchronously
func (client *Client) ListServiceInstanceResourcesWithCallback(request *ListServiceInstanceResourcesRequest, callback func(response *ListServiceInstanceResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListServiceInstanceResourcesResponse
		var err error
		defer close(result)
		response, err = client.ListServiceInstanceResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListServiceInstanceResourcesRequest is the request struct for api ListServiceInstanceResources
type ListServiceInstanceResourcesRequest struct {
	*requests.RpcRequest
	ExpireTimeEnd               string                             `position:"Query" name:"ExpireTimeEnd"`
	NextToken                   string                             `position:"Query" name:"NextToken"`
	ServiceInstanceResourceType string                             `position:"Query" name:"ServiceInstanceResourceType"`
	ResourceARN                 *[]string                          `position:"Query" name:"ResourceARN"  type:"Repeated"`
	Tag                         *[]ListServiceInstanceResourcesTag `position:"Query" name:"Tag"  type:"Repeated"`
	ServiceInstanceId           string                             `position:"Query" name:"ServiceInstanceId"`
	ExpireTimeStart             string                             `position:"Query" name:"ExpireTimeStart"`
	MaxResults                  requests.Integer                   `position:"Query" name:"MaxResults"`
	PayType                     string                             `position:"Query" name:"PayType"`
}

// ListServiceInstanceResourcesTag is a repeated param struct in ListServiceInstanceResourcesRequest
type ListServiceInstanceResourcesTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// ListServiceInstanceResourcesResponse is the response struct for api ListServiceInstanceResources
type ListServiceInstanceResourcesResponse struct {
	*responses.BaseResponse
	NextToken  string          `json:"NextToken" xml:"NextToken"`
	RequestId  string          `json:"RequestId" xml:"RequestId"`
	MaxResults int             `json:"MaxResults" xml:"MaxResults"`
	Resources  []ResourcesItem `json:"Resources" xml:"Resources"`
}

// CreateListServiceInstanceResourcesRequest creates a request to invoke ListServiceInstanceResources API
func CreateListServiceInstanceResourcesRequest() (request *ListServiceInstanceResourcesRequest) {
	request = &ListServiceInstanceResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNest", "2021-06-01", "ListServiceInstanceResources", "computenest", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListServiceInstanceResourcesResponse creates a response to parse from ListServiceInstanceResources response
func CreateListServiceInstanceResourcesResponse() (response *ListServiceInstanceResourcesResponse) {
	response = &ListServiceInstanceResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
