package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAggregateConfigRule invokes the config.UpdateAggregateConfigRule API synchronously
func (client *Client) UpdateAggregateConfigRule(request *UpdateAggregateConfigRuleRequest) (response *UpdateAggregateConfigRuleResponse, err error) {
	response = CreateUpdateAggregateConfigRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAggregateConfigRuleWithChan invokes the config.UpdateAggregateConfigRule API asynchronously
func (client *Client) UpdateAggregateConfigRuleWithChan(request *UpdateAggregateConfigRuleRequest) (<-chan *UpdateAggregateConfigRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateAggregateConfigRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAggregateConfigRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAggregateConfigRuleWithCallback invokes the config.UpdateAggregateConfigRule API asynchronously
func (client *Client) UpdateAggregateConfigRuleWithCallback(request *UpdateAggregateConfigRuleRequest, callback func(response *UpdateAggregateConfigRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAggregateConfigRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateAggregateConfigRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAggregateConfigRuleRequest is the request struct for api UpdateAggregateConfigRule
type UpdateAggregateConfigRuleRequest struct {
	*requests.RpcRequest
	ConfigRuleId              string           `position:"Body" name:"ConfigRuleId"`
	TagKeyScope               string           `position:"Body" name:"TagKeyScope"`
	ClientToken               string           `position:"Body" name:"ClientToken"`
	ResourceTypesScope        *[]string        `position:"Body" name:"ResourceTypesScope"  type:"Repeated"`
	Description               string           `position:"Body" name:"Description"`
	AggregatorId              string           `position:"Body" name:"AggregatorId"`
	ConfigRuleTriggerTypes    string           `position:"Body" name:"ConfigRuleTriggerTypes"`
	TagValueScope             string           `position:"Body" name:"TagValueScope"`
	ExcludeAccountIdsScope    string           `position:"Body" name:"ExcludeAccountIdsScope"`
	RegionIdsScope            string           `position:"Body" name:"RegionIdsScope"`
	ExcludeFolderIdsScope     string           `position:"Body" name:"ExcludeFolderIdsScope"`
	RiskLevel                 requests.Integer `position:"Body" name:"RiskLevel"`
	ResourceGroupIdsScope     string           `position:"Body" name:"ResourceGroupIdsScope"`
	InputParameters           string           `position:"Body" name:"InputParameters"`
	ConfigRuleName            string           `position:"Body" name:"ConfigRuleName"`
	TagKeyLogicScope          string           `position:"Body" name:"TagKeyLogicScope"`
	MaximumExecutionFrequency string           `position:"Body" name:"MaximumExecutionFrequency"`
	FolderIdsScope            string           `position:"Body" name:"FolderIdsScope"`
	ExcludeResourceIdsScope   string           `position:"Body" name:"ExcludeResourceIdsScope"`
	Conditions                string           `position:"Body" name:"Conditions"`
}

// UpdateAggregateConfigRuleResponse is the response struct for api UpdateAggregateConfigRule
type UpdateAggregateConfigRuleResponse struct {
	*responses.BaseResponse
	ConfigRuleId string `json:"ConfigRuleId" xml:"ConfigRuleId"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAggregateConfigRuleRequest creates a request to invoke UpdateAggregateConfigRule API
func CreateUpdateAggregateConfigRuleRequest() (request *UpdateAggregateConfigRuleRequest) {
	request = &UpdateAggregateConfigRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "UpdateAggregateConfigRule", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateAggregateConfigRuleResponse creates a response to parse from UpdateAggregateConfigRule response
func CreateUpdateAggregateConfigRuleResponse() (response *UpdateAggregateConfigRuleResponse) {
	response = &UpdateAggregateConfigRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
