package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateIntegratedServiceStatus invokes the config.UpdateIntegratedServiceStatus API synchronously
func (client *Client) UpdateIntegratedServiceStatus(request *UpdateIntegratedServiceStatusRequest) (response *UpdateIntegratedServiceStatusResponse, err error) {
	response = CreateUpdateIntegratedServiceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateIntegratedServiceStatusWithChan invokes the config.UpdateIntegratedServiceStatus API asynchronously
func (client *Client) UpdateIntegratedServiceStatusWithChan(request *UpdateIntegratedServiceStatusRequest) (<-chan *UpdateIntegratedServiceStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateIntegratedServiceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateIntegratedServiceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateIntegratedServiceStatusWithCallback invokes the config.UpdateIntegratedServiceStatus API asynchronously
func (client *Client) UpdateIntegratedServiceStatusWithCallback(request *UpdateIntegratedServiceStatusRequest, callback func(response *UpdateIntegratedServiceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateIntegratedServiceStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateIntegratedServiceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateIntegratedServiceStatusRequest is the request struct for api UpdateIntegratedServiceStatus
type UpdateIntegratedServiceStatusRequest struct {
	*requests.RpcRequest
	ServiceCode string           `position:"Body" name:"ServiceCode"`
	Status      requests.Boolean `position:"Body" name:"Status"`
}

// UpdateIntegratedServiceStatusResponse is the response struct for api UpdateIntegratedServiceStatus
type UpdateIntegratedServiceStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateIntegratedServiceStatusRequest creates a request to invoke UpdateIntegratedServiceStatus API
func CreateUpdateIntegratedServiceStatusRequest() (request *UpdateIntegratedServiceStatusRequest) {
	request = &UpdateIntegratedServiceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "UpdateIntegratedServiceStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateIntegratedServiceStatusResponse creates a response to parse from UpdateIntegratedServiceStatus response
func CreateUpdateIntegratedServiceStatusResponse() (response *UpdateIntegratedServiceStatusResponse) {
	response = &UpdateIntegratedServiceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
