package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRegistrationPolicies invokes the csas.DeleteRegistrationPolicies API synchronously
func (client *Client) DeleteRegistrationPolicies(request *DeleteRegistrationPoliciesRequest) (response *DeleteRegistrationPoliciesResponse, err error) {
	response = CreateDeleteRegistrationPoliciesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRegistrationPoliciesWithChan invokes the csas.DeleteRegistrationPolicies API asynchronously
func (client *Client) DeleteRegistrationPoliciesWithChan(request *DeleteRegistrationPoliciesRequest) (<-chan *DeleteRegistrationPoliciesResponse, <-chan error) {
	responseChan := make(chan *DeleteRegistrationPoliciesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRegistrationPolicies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRegistrationPoliciesWithCallback invokes the csas.DeleteRegistrationPolicies API asynchronously
func (client *Client) DeleteRegistrationPoliciesWithCallback(request *DeleteRegistrationPoliciesRequest, callback func(response *DeleteRegistrationPoliciesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRegistrationPoliciesResponse
		var err error
		defer close(result)
		response, err = client.DeleteRegistrationPolicies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRegistrationPoliciesRequest is the request struct for api DeleteRegistrationPolicies
type DeleteRegistrationPoliciesRequest struct {
	*requests.RpcRequest
	PolicyIds *[]string `position:"Body" name:"PolicyIds"  type:"Repeated"`
	SourceIp  string    `position:"Query" name:"SourceIp"`
}

// DeleteRegistrationPoliciesResponse is the response struct for api DeleteRegistrationPolicies
type DeleteRegistrationPoliciesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteRegistrationPoliciesRequest creates a request to invoke DeleteRegistrationPolicies API
func CreateDeleteRegistrationPoliciesRequest() (request *DeleteRegistrationPoliciesRequest) {
	request = &DeleteRegistrationPoliciesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "DeleteRegistrationPolicies", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteRegistrationPoliciesResponse creates a response to parse from DeleteRegistrationPolicies response
func CreateDeleteRegistrationPoliciesResponse() (response *DeleteRegistrationPoliciesResponse) {
	response = &DeleteRegistrationPoliciesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
