package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUninstallApplications invokes the csas.ListUninstallApplications API synchronously
func (client *Client) ListUninstallApplications(request *ListUninstallApplicationsRequest) (response *ListUninstallApplicationsResponse, err error) {
	response = CreateListUninstallApplicationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListUninstallApplicationsWithChan invokes the csas.ListUninstallApplications API asynchronously
func (client *Client) ListUninstallApplicationsWithChan(request *ListUninstallApplicationsRequest) (<-chan *ListUninstallApplicationsResponse, <-chan error) {
	responseChan := make(chan *ListUninstallApplicationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUninstallApplications(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUninstallApplicationsWithCallback invokes the csas.ListUninstallApplications API asynchronously
func (client *Client) ListUninstallApplicationsWithCallback(request *ListUninstallApplicationsRequest, callback func(response *ListUninstallApplicationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUninstallApplicationsResponse
		var err error
		defer close(result)
		response, err = client.ListUninstallApplications(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUninstallApplicationsRequest is the request struct for api ListUninstallApplications
type ListUninstallApplicationsRequest struct {
	*requests.RpcRequest
	Mac            string           `position:"Query" name:"Mac"`
	Hostname       string           `position:"Query" name:"Hostname"`
	SourceIp       string           `position:"Query" name:"SourceIp"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	Department     string           `position:"Query" name:"Department"`
	CurrentPage    requests.Integer `position:"Query" name:"CurrentPage"`
	ApplicationIds *[]string        `position:"Query" name:"ApplicationIds"  type:"Repeated"`
	Statuses       *[]string        `position:"Query" name:"Statuses"  type:"Repeated"`
	Username       string           `position:"Query" name:"Username"`
}

// ListUninstallApplicationsResponse is the response struct for api ListUninstallApplications
type ListUninstallApplicationsResponse struct {
	*responses.BaseResponse
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	TotalNum     int64      `json:"TotalNum" xml:"TotalNum"`
	Applications []DataList `json:"Applications" xml:"Applications"`
}

// CreateListUninstallApplicationsRequest creates a request to invoke ListUninstallApplications API
func CreateListUninstallApplicationsRequest() (request *ListUninstallApplicationsRequest) {
	request = &ListUninstallApplicationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListUninstallApplications", "", "")
	request.Method = requests.GET
	return
}

// CreateListUninstallApplicationsResponse creates a response to parse from ListUninstallApplications response
func CreateListUninstallApplicationsResponse() (response *ListUninstallApplicationsResponse) {
	response = &ListUninstallApplicationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
