package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateClientUser invokes the csas.UpdateClientUser API synchronously
func (client *Client) UpdateClientUser(request *UpdateClientUserRequest) (response *UpdateClientUserResponse, err error) {
	response = CreateUpdateClientUserResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateClientUserWithChan invokes the csas.UpdateClientUser API asynchronously
func (client *Client) UpdateClientUserWithChan(request *UpdateClientUserRequest) (<-chan *UpdateClientUserResponse, <-chan error) {
	responseChan := make(chan *UpdateClientUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateClientUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateClientUserWithCallback invokes the csas.UpdateClientUser API asynchronously
func (client *Client) UpdateClientUserWithCallback(request *UpdateClientUserRequest, callback func(response *UpdateClientUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateClientUserResponse
		var err error
		defer close(result)
		response, err = client.UpdateClientUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateClientUserRequest is the request struct for api UpdateClientUser
type UpdateClientUserRequest struct {
	*requests.RpcRequest
	MobileNumber string `position:"Query" name:"MobileNumber"`
	DepartmentId string `position:"Query" name:"DepartmentId"`
	Description  string `position:"Query" name:"Description"`
	Id           string `position:"Query" name:"Id"`
	Email        string `position:"Query" name:"Email"`
}

// UpdateClientUserResponse is the response struct for api UpdateClientUser
type UpdateClientUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateClientUserRequest creates a request to invoke UpdateClientUser API
func CreateUpdateClientUserRequest() (request *UpdateClientUserRequest) {
	request = &UpdateClientUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "UpdateClientUser", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateClientUserResponse creates a response to parse from UpdateClientUser response
func CreateUpdateClientUserResponse() (response *UpdateClientUserResponse) {
	response = &UpdateClientUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
