package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdatePrivateAccessPolicy invokes the csas.UpdatePrivateAccessPolicy API synchronously
func (client *Client) UpdatePrivateAccessPolicy(request *UpdatePrivateAccessPolicyRequest) (response *UpdatePrivateAccessPolicyResponse, err error) {
	response = CreateUpdatePrivateAccessPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// UpdatePrivateAccessPolicyWithChan invokes the csas.UpdatePrivateAccessPolicy API asynchronously
func (client *Client) UpdatePrivateAccessPolicyWithChan(request *UpdatePrivateAccessPolicyRequest) (<-chan *UpdatePrivateAccessPolicyResponse, <-chan error) {
	responseChan := make(chan *UpdatePrivateAccessPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdatePrivateAccessPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdatePrivateAccessPolicyWithCallback invokes the csas.UpdatePrivateAccessPolicy API asynchronously
func (client *Client) UpdatePrivateAccessPolicyWithCallback(request *UpdatePrivateAccessPolicyRequest, callback func(response *UpdatePrivateAccessPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdatePrivateAccessPolicyResponse
		var err error
		defer close(result)
		response, err = client.UpdatePrivateAccessPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdatePrivateAccessPolicyRequest is the request struct for api UpdatePrivateAccessPolicy
type UpdatePrivateAccessPolicyRequest struct {
	*requests.RpcRequest
	Description           string                                           `position:"Body" name:"Description"`
	SourceIp              string                                           `position:"Query" name:"SourceIp"`
	PolicyId              string                                           `position:"Body" name:"PolicyId"`
	CustomUserAttributes  *[]UpdatePrivateAccessPolicyCustomUserAttributes `position:"Body" name:"CustomUserAttributes"  type:"Repeated"`
	TagIds                *[]string                                        `position:"Body" name:"TagIds"  type:"Repeated"`
	DeviceAttributeId     string                                           `position:"Body" name:"DeviceAttributeId"`
	UserGroupIds          *[]string                                        `position:"Body" name:"UserGroupIds"  type:"Repeated"`
	PolicyAction          string                                           `position:"Body" name:"PolicyAction"`
	Priority              requests.Integer                                 `position:"Body" name:"Priority"`
	DeviceAttributeAction string                                           `position:"Body" name:"DeviceAttributeAction"`
	ApplicationIds        *[]string                                        `position:"Body" name:"ApplicationIds"  type:"Repeated"`
	UserGroupMode         string                                           `position:"Body" name:"UserGroupMode"`
	ModifyType            string                                           `position:"Body" name:"ModifyType"`
	ApplicationType       string                                           `position:"Body" name:"ApplicationType"`
	Status                string                                           `position:"Body" name:"Status"`
}

// UpdatePrivateAccessPolicyCustomUserAttributes is a repeated param struct in UpdatePrivateAccessPolicyRequest
type UpdatePrivateAccessPolicyCustomUserAttributes struct {
	UserGroupType string `name:"UserGroupType"`
	IdpId         string `name:"IdpId"`
	Value         string `name:"Value"`
	Relation      string `name:"Relation"`
}

// UpdatePrivateAccessPolicyResponse is the response struct for api UpdatePrivateAccessPolicy
type UpdatePrivateAccessPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdatePrivateAccessPolicyRequest creates a request to invoke UpdatePrivateAccessPolicy API
func CreateUpdatePrivateAccessPolicyRequest() (request *UpdatePrivateAccessPolicyRequest) {
	request = &UpdatePrivateAccessPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "UpdatePrivateAccessPolicy", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdatePrivateAccessPolicyResponse creates a response to parse from UpdatePrivateAccessPolicy response
func CreateUpdatePrivateAccessPolicyResponse() (response *UpdatePrivateAccessPolicyResponse) {
	response = &UpdatePrivateAccessPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
