package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateUsersStatus invokes the csas.UpdateUsersStatus API synchronously
func (client *Client) UpdateUsersStatus(request *UpdateUsersStatusRequest) (response *UpdateUsersStatusResponse, err error) {
	response = CreateUpdateUsersStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateUsersStatusWithChan invokes the csas.UpdateUsersStatus API asynchronously
func (client *Client) UpdateUsersStatusWithChan(request *UpdateUsersStatusRequest) (<-chan *UpdateUsersStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateUsersStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateUsersStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateUsersStatusWithCallback invokes the csas.UpdateUsersStatus API asynchronously
func (client *Client) UpdateUsersStatusWithCallback(request *UpdateUsersStatusRequest, callback func(response *UpdateUsersStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateUsersStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateUsersStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateUsersStatusRequest is the request struct for api UpdateUsersStatus
type UpdateUsersStatusRequest struct {
	*requests.RpcRequest
	SaseUserIds *[]string `position:"Query" name:"SaseUserIds"  type:"Repeated"`
	SourceIp    string    `position:"Query" name:"SourceIp"`
	Status      string    `position:"Query" name:"Status"`
}

// UpdateUsersStatusResponse is the response struct for api UpdateUsersStatus
type UpdateUsersStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateUsersStatusRequest creates a request to invoke UpdateUsersStatus API
func CreateUpdateUsersStatusRequest() (request *UpdateUsersStatusRequest) {
	request = &UpdateUsersStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "UpdateUsersStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateUsersStatusResponse creates a response to parse from UpdateUsersStatus response
func CreateUpdateUsersStatusResponse() (response *UpdateUsersStatusResponse) {
	response = &UpdateUsersStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
