package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableAutoThrottleRules invokes the das.DisableAutoThrottleRules API synchronously
func (client *Client) DisableAutoThrottleRules(request *DisableAutoThrottleRulesRequest) (response *DisableAutoThrottleRulesResponse, err error) {
	response = CreateDisableAutoThrottleRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DisableAutoThrottleRulesWithChan invokes the das.DisableAutoThrottleRules API asynchronously
func (client *Client) DisableAutoThrottleRulesWithChan(request *DisableAutoThrottleRulesRequest) (<-chan *DisableAutoThrottleRulesResponse, <-chan error) {
	responseChan := make(chan *DisableAutoThrottleRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableAutoThrottleRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableAutoThrottleRulesWithCallback invokes the das.DisableAutoThrottleRules API asynchronously
func (client *Client) DisableAutoThrottleRulesWithCallback(request *DisableAutoThrottleRulesRequest, callback func(response *DisableAutoThrottleRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableAutoThrottleRulesResponse
		var err error
		defer close(result)
		response, err = client.DisableAutoThrottleRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableAutoThrottleRulesRequest is the request struct for api DisableAutoThrottleRules
type DisableAutoThrottleRulesRequest struct {
	*requests.RpcRequest
	ConsoleContext string `position:"Query" name:"ConsoleContext"`
	InstanceIds    string `position:"Query" name:"InstanceIds"`
}

// DisableAutoThrottleRulesResponse is the response struct for api DisableAutoThrottleRules
type DisableAutoThrottleRulesResponse struct {
	*responses.BaseResponse
	Code      int64  `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDisableAutoThrottleRulesRequest creates a request to invoke DisableAutoThrottleRules API
func CreateDisableAutoThrottleRulesRequest() (request *DisableAutoThrottleRulesRequest) {
	request = &DisableAutoThrottleRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "DisableAutoThrottleRules", "", "")
	request.Method = requests.POST
	return
}

// CreateDisableAutoThrottleRulesResponse creates a response to parse from DisableAutoThrottleRules response
func CreateDisableAutoThrottleRulesResponse() (response *DisableAutoThrottleRulesResponse) {
	response = &DisableAutoThrottleRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
