package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQueryOptimizeTag invokes the das.GetQueryOptimizeTag API synchronously
func (client *Client) GetQueryOptimizeTag(request *GetQueryOptimizeTagRequest) (response *GetQueryOptimizeTagResponse, err error) {
	response = CreateGetQueryOptimizeTagResponse()
	err = client.DoAction(request, response)
	return
}

// GetQueryOptimizeTagWithChan invokes the das.GetQueryOptimizeTag API asynchronously
func (client *Client) GetQueryOptimizeTagWithChan(request *GetQueryOptimizeTagRequest) (<-chan *GetQueryOptimizeTagResponse, <-chan error) {
	responseChan := make(chan *GetQueryOptimizeTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQueryOptimizeTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQueryOptimizeTagWithCallback invokes the das.GetQueryOptimizeTag API asynchronously
func (client *Client) GetQueryOptimizeTagWithCallback(request *GetQueryOptimizeTagRequest, callback func(response *GetQueryOptimizeTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQueryOptimizeTagResponse
		var err error
		defer close(result)
		response, err = client.GetQueryOptimizeTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQueryOptimizeTagRequest is the request struct for api GetQueryOptimizeTag
type GetQueryOptimizeTagRequest struct {
	*requests.RpcRequest
	ConsoleContext string `position:"Query" name:"ConsoleContext"`
	Engine         string `position:"Query" name:"Engine"`
	SqlId          string `position:"Query" name:"SqlId"`
	InstanceId     string `position:"Query" name:"InstanceId"`
}

// GetQueryOptimizeTagResponse is the response struct for api GetQueryOptimizeTag
type GetQueryOptimizeTagResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetQueryOptimizeTagRequest creates a request to invoke GetQueryOptimizeTag API
func CreateGetQueryOptimizeTagRequest() (request *GetQueryOptimizeTagRequest) {
	request = &GetQueryOptimizeTagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetQueryOptimizeTag", "", "")
	request.Method = requests.GET
	return
}

// CreateGetQueryOptimizeTagResponse creates a response to parse from GetQueryOptimizeTag response
func CreateGetQueryOptimizeTagResponse() (response *GetQueryOptimizeTagResponse) {
	response = &GetQueryOptimizeTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
