package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAutoResourceOptimizeRulesAsync invokes the das.UpdateAutoResourceOptimizeRulesAsync API synchronously
func (client *Client) UpdateAutoResourceOptimizeRulesAsync(request *UpdateAutoResourceOptimizeRulesAsyncRequest) (response *UpdateAutoResourceOptimizeRulesAsyncResponse, err error) {
	response = CreateUpdateAutoResourceOptimizeRulesAsyncResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAutoResourceOptimizeRulesAsyncWithChan invokes the das.UpdateAutoResourceOptimizeRulesAsync API asynchronously
func (client *Client) UpdateAutoResourceOptimizeRulesAsyncWithChan(request *UpdateAutoResourceOptimizeRulesAsyncRequest) (<-chan *UpdateAutoResourceOptimizeRulesAsyncResponse, <-chan error) {
	responseChan := make(chan *UpdateAutoResourceOptimizeRulesAsyncResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAutoResourceOptimizeRulesAsync(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAutoResourceOptimizeRulesAsyncWithCallback invokes the das.UpdateAutoResourceOptimizeRulesAsync API asynchronously
func (client *Client) UpdateAutoResourceOptimizeRulesAsyncWithCallback(request *UpdateAutoResourceOptimizeRulesAsyncRequest, callback func(response *UpdateAutoResourceOptimizeRulesAsyncResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAutoResourceOptimizeRulesAsyncResponse
		var err error
		defer close(result)
		response, err = client.UpdateAutoResourceOptimizeRulesAsync(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAutoResourceOptimizeRulesAsyncRequest is the request struct for api UpdateAutoResourceOptimizeRulesAsync
type UpdateAutoResourceOptimizeRulesAsyncRequest struct {
	*requests.RpcRequest
	ResultId                string `position:"Query" name:"ResultId"`
	ConsoleContext          string `position:"Query" name:"ConsoleContext"`
	InstanceIds             string `position:"Query" name:"InstanceIds"`
	TableSpaceSize          string `position:"Query" name:"TableSpaceSize"`
	TableFragmentationRatio string `position:"Query" name:"TableFragmentationRatio"`
}

// UpdateAutoResourceOptimizeRulesAsyncResponse is the response struct for api UpdateAutoResourceOptimizeRulesAsync
type UpdateAutoResourceOptimizeRulesAsyncResponse struct {
	*responses.BaseResponse
	Code      int64  `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateUpdateAutoResourceOptimizeRulesAsyncRequest creates a request to invoke UpdateAutoResourceOptimizeRulesAsync API
func CreateUpdateAutoResourceOptimizeRulesAsyncRequest() (request *UpdateAutoResourceOptimizeRulesAsyncRequest) {
	request = &UpdateAutoResourceOptimizeRulesAsyncRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "UpdateAutoResourceOptimizeRulesAsync", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateAutoResourceOptimizeRulesAsyncResponse creates a response to parse from UpdateAutoResourceOptimizeRulesAsync response
func CreateUpdateAutoResourceOptimizeRulesAsyncResponse() (response *UpdateAutoResourceOptimizeRulesAsyncResponse) {
	response = &UpdateAutoResourceOptimizeRulesAsyncResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
