package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImportDataSources invokes the dataworks_public.ImportDataSources API synchronously
func (client *Client) ImportDataSources(request *ImportDataSourcesRequest) (response *ImportDataSourcesResponse, err error) {
	response = CreateImportDataSourcesResponse()
	err = client.DoAction(request, response)
	return
}

// ImportDataSourcesWithChan invokes the dataworks_public.ImportDataSources API asynchronously
func (client *Client) ImportDataSourcesWithChan(request *ImportDataSourcesRequest) (<-chan *ImportDataSourcesResponse, <-chan error) {
	responseChan := make(chan *ImportDataSourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImportDataSources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImportDataSourcesWithCallback invokes the dataworks_public.ImportDataSources API asynchronously
func (client *Client) ImportDataSourcesWithCallback(request *ImportDataSourcesRequest, callback func(response *ImportDataSourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImportDataSourcesResponse
		var err error
		defer close(result)
		response, err = client.ImportDataSources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImportDataSourcesRequest is the request struct for api ImportDataSources
type ImportDataSourcesRequest struct {
	*requests.RpcRequest
	DataSources string           `position:"Query" name:"DataSources"`
	ProjectId   requests.Integer `position:"Query" name:"ProjectId"`
}

// ImportDataSourcesResponse is the response struct for api ImportDataSources
type ImportDataSourcesResponse struct {
	*responses.BaseResponse
	Success   bool                    `json:"Success" xml:"Success"`
	RequestId string                  `json:"RequestId" xml:"RequestId"`
	Data      DataInImportDataSources `json:"Data" xml:"Data"`
}

// CreateImportDataSourcesRequest creates a request to invoke ImportDataSources API
func CreateImportDataSourcesRequest() (request *ImportDataSourcesRequest) {
	request = &ImportDataSourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ImportDataSources", "", "")
	request.Method = requests.POST
	return
}

// CreateImportDataSourcesResponse creates a response to parse from ImportDataSources response
func CreateImportDataSourcesResponse() (response *ImportDataSourcesResponse) {
	response = &ImportDataSourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
