package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMetaDB invokes the dataworks_public.ListMetaDB API synchronously
func (client *Client) ListMetaDB(request *ListMetaDBRequest) (response *ListMetaDBResponse, err error) {
	response = CreateListMetaDBResponse()
	err = client.DoAction(request, response)
	return
}

// ListMetaDBWithChan invokes the dataworks_public.ListMetaDB API asynchronously
func (client *Client) ListMetaDBWithChan(request *ListMetaDBRequest) (<-chan *ListMetaDBResponse, <-chan error) {
	responseChan := make(chan *ListMetaDBResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMetaDB(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMetaDBWithCallback invokes the dataworks_public.ListMetaDB API asynchronously
func (client *Client) ListMetaDBWithCallback(request *ListMetaDBRequest, callback func(response *ListMetaDBResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMetaDBResponse
		var err error
		defer close(result)
		response, err = client.ListMetaDB(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMetaDBRequest is the request struct for api ListMetaDB
type ListMetaDBRequest struct {
	*requests.RpcRequest
	DataSourceType string           `position:"Query" name:"DataSourceType"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	PageNum        requests.Integer `position:"Query" name:"PageNum"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	ProjectId      requests.Integer `position:"Query" name:"ProjectId"`
}

// ListMetaDBResponse is the response struct for api ListMetaDB
type ListMetaDBResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	DatabaseInfo DatabaseInfo `json:"DatabaseInfo" xml:"DatabaseInfo"`
}

// CreateListMetaDBRequest creates a request to invoke ListMetaDB API
func CreateListMetaDBRequest() (request *ListMetaDBRequest) {
	request = &ListMetaDBRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListMetaDB", "", "")
	request.Method = requests.GET
	return
}

// CreateListMetaDBResponse creates a response to parse from ListMetaDB response
func CreateListMetaDBResponse() (response *ListMetaDBResponse) {
	response = &ListMetaDBResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
