package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListShiftSchedules invokes the dataworks_public.ListShiftSchedules API synchronously
func (client *Client) ListShiftSchedules(request *ListShiftSchedulesRequest) (response *ListShiftSchedulesResponse, err error) {
	response = CreateListShiftSchedulesResponse()
	err = client.DoAction(request, response)
	return
}

// ListShiftSchedulesWithChan invokes the dataworks_public.ListShiftSchedules API asynchronously
func (client *Client) ListShiftSchedulesWithChan(request *ListShiftSchedulesRequest) (<-chan *ListShiftSchedulesResponse, <-chan error) {
	responseChan := make(chan *ListShiftSchedulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListShiftSchedules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListShiftSchedulesWithCallback invokes the dataworks_public.ListShiftSchedules API asynchronously
func (client *Client) ListShiftSchedulesWithCallback(request *ListShiftSchedulesRequest, callback func(response *ListShiftSchedulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListShiftSchedulesResponse
		var err error
		defer close(result)
		response, err = client.ListShiftSchedules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListShiftSchedulesRequest is the request struct for api ListShiftSchedules
type ListShiftSchedulesRequest struct {
	*requests.RpcRequest
	Owner             string           `position:"Body" name:"Owner"`
	PageSize          requests.Integer `position:"Body" name:"PageSize"`
	ShiftScheduleName string           `position:"Body" name:"ShiftScheduleName"`
	PageNumber        requests.Integer `position:"Body" name:"PageNumber"`
}

// ListShiftSchedulesResponse is the response struct for api ListShiftSchedules
type ListShiftSchedulesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Paging    Paging `json:"Paging" xml:"Paging"`
}

// CreateListShiftSchedulesRequest creates a request to invoke ListShiftSchedules API
func CreateListShiftSchedulesRequest() (request *ListShiftSchedulesRequest) {
	request = &ListShiftSchedulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListShiftSchedules", "", "")
	request.Method = requests.POST
	return
}

// CreateListShiftSchedulesResponse creates a response to parse from ListShiftSchedules response
func CreateListShiftSchedulesResponse() (response *ListShiftSchedulesResponse) {
	response = &ListShiftSchedulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
