package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TerminateDISyncInstance invokes the dataworks_public.TerminateDISyncInstance API synchronously
func (client *Client) TerminateDISyncInstance(request *TerminateDISyncInstanceRequest) (response *TerminateDISyncInstanceResponse, err error) {
	response = CreateTerminateDISyncInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// TerminateDISyncInstanceWithChan invokes the dataworks_public.TerminateDISyncInstance API asynchronously
func (client *Client) TerminateDISyncInstanceWithChan(request *TerminateDISyncInstanceRequest) (<-chan *TerminateDISyncInstanceResponse, <-chan error) {
	responseChan := make(chan *TerminateDISyncInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TerminateDISyncInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TerminateDISyncInstanceWithCallback invokes the dataworks_public.TerminateDISyncInstance API asynchronously
func (client *Client) TerminateDISyncInstanceWithCallback(request *TerminateDISyncInstanceRequest, callback func(response *TerminateDISyncInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TerminateDISyncInstanceResponse
		var err error
		defer close(result)
		response, err = client.TerminateDISyncInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TerminateDISyncInstanceRequest is the request struct for api TerminateDISyncInstance
type TerminateDISyncInstanceRequest struct {
	*requests.RpcRequest
	TaskType  string           `position:"Query" name:"TaskType"`
	ProjectId requests.Integer `position:"Query" name:"ProjectId"`
	FileId    requests.Integer `position:"Query" name:"FileId"`
}

// TerminateDISyncInstanceResponse is the response struct for api TerminateDISyncInstance
type TerminateDISyncInstanceResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateTerminateDISyncInstanceRequest creates a request to invoke TerminateDISyncInstance API
func CreateTerminateDISyncInstanceRequest() (request *TerminateDISyncInstanceRequest) {
	request = &TerminateDISyncInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "TerminateDISyncInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateTerminateDISyncInstanceResponse creates a response to parse from TerminateDISyncInstance response
func CreateTerminateDISyncInstanceResponse() (response *TerminateDISyncInstanceResponse) {
	response = &TerminateDISyncInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
