package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAutoSnapshotPolicyUnappliedDbfs invokes the dbfs.ListAutoSnapshotPolicyUnappliedDbfs API synchronously
func (client *Client) ListAutoSnapshotPolicyUnappliedDbfs(request *ListAutoSnapshotPolicyUnappliedDbfsRequest) (response *ListAutoSnapshotPolicyUnappliedDbfsResponse, err error) {
	response = CreateListAutoSnapshotPolicyUnappliedDbfsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAutoSnapshotPolicyUnappliedDbfsWithChan invokes the dbfs.ListAutoSnapshotPolicyUnappliedDbfs API asynchronously
func (client *Client) ListAutoSnapshotPolicyUnappliedDbfsWithChan(request *ListAutoSnapshotPolicyUnappliedDbfsRequest) (<-chan *ListAutoSnapshotPolicyUnappliedDbfsResponse, <-chan error) {
	responseChan := make(chan *ListAutoSnapshotPolicyUnappliedDbfsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAutoSnapshotPolicyUnappliedDbfs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAutoSnapshotPolicyUnappliedDbfsWithCallback invokes the dbfs.ListAutoSnapshotPolicyUnappliedDbfs API asynchronously
func (client *Client) ListAutoSnapshotPolicyUnappliedDbfsWithCallback(request *ListAutoSnapshotPolicyUnappliedDbfsRequest, callback func(response *ListAutoSnapshotPolicyUnappliedDbfsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAutoSnapshotPolicyUnappliedDbfsResponse
		var err error
		defer close(result)
		response, err = client.ListAutoSnapshotPolicyUnappliedDbfs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAutoSnapshotPolicyUnappliedDbfsRequest is the request struct for api ListAutoSnapshotPolicyUnappliedDbfs
type ListAutoSnapshotPolicyUnappliedDbfsRequest struct {
	*requests.RpcRequest
	FilterValue string           `position:"Query" name:"FilterValue"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
	FilterKey   string           `position:"Query" name:"FilterKey"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// ListAutoSnapshotPolicyUnappliedDbfsResponse is the response struct for api ListAutoSnapshotPolicyUnappliedDbfs
type ListAutoSnapshotPolicyUnappliedDbfsResponse struct {
	*responses.BaseResponse
	PageNumber int            `json:"PageNumber" xml:"PageNumber"`
	PageSize   int            `json:"PageSize" xml:"PageSize"`
	TotalCount int            `json:"TotalCount" xml:"TotalCount"`
	RequestId  string         `json:"RequestId" xml:"RequestId"`
	DbfsList   []DbfsListItem `json:"DbfsList" xml:"DbfsList"`
}

// CreateListAutoSnapshotPolicyUnappliedDbfsRequest creates a request to invoke ListAutoSnapshotPolicyUnappliedDbfs API
func CreateListAutoSnapshotPolicyUnappliedDbfsRequest() (request *ListAutoSnapshotPolicyUnappliedDbfsRequest) {
	request = &ListAutoSnapshotPolicyUnappliedDbfsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "ListAutoSnapshotPolicyUnappliedDbfs", "dbfs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAutoSnapshotPolicyUnappliedDbfsResponse creates a response to parse from ListAutoSnapshotPolicyUnappliedDbfs response
func CreateListAutoSnapshotPolicyUnappliedDbfsResponse() (response *ListAutoSnapshotPolicyUnappliedDbfsResponse) {
	response = &ListAutoSnapshotPolicyUnappliedDbfsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
