package dbs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAndStartBackupPlan invokes the dbs.CreateAndStartBackupPlan API synchronously
func (client *Client) CreateAndStartBackupPlan(request *CreateAndStartBackupPlanRequest) (response *CreateAndStartBackupPlanResponse, err error) {
	response = CreateCreateAndStartBackupPlanResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAndStartBackupPlanWithChan invokes the dbs.CreateAndStartBackupPlan API asynchronously
func (client *Client) CreateAndStartBackupPlanWithChan(request *CreateAndStartBackupPlanRequest) (<-chan *CreateAndStartBackupPlanResponse, <-chan error) {
	responseChan := make(chan *CreateAndStartBackupPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAndStartBackupPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAndStartBackupPlanWithCallback invokes the dbs.CreateAndStartBackupPlan API asynchronously
func (client *Client) CreateAndStartBackupPlanWithCallback(request *CreateAndStartBackupPlanRequest, callback func(response *CreateAndStartBackupPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAndStartBackupPlanResponse
		var err error
		defer close(result)
		response, err = client.CreateAndStartBackupPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAndStartBackupPlanRequest is the request struct for api CreateAndStartBackupPlan
type CreateAndStartBackupPlanRequest struct {
	*requests.RpcRequest
	DatabaseType                      string           `position:"Query" name:"DatabaseType"`
	BackupGatewayId                   requests.Integer `position:"Query" name:"BackupGatewayId"`
	SourceEndpointUserName            string           `position:"Query" name:"SourceEndpointUserName"`
	StorageType                       string           `position:"Query" name:"StorageType"`
	DatabaseRegion                    string           `position:"Query" name:"DatabaseRegion"`
	ResourceGroupId                   string           `position:"Query" name:"ResourceGroupId"`
	BackupStartTime                   string           `position:"Query" name:"BackupStartTime"`
	SourceEndpointIP                  string           `position:"Query" name:"SourceEndpointIP"`
	CrossRoleName                     string           `position:"Query" name:"CrossRoleName"`
	BackupStorageType                 string           `position:"Query" name:"BackupStorageType"`
	DuplicationArchivePeriod          requests.Integer `position:"Query" name:"DuplicationArchivePeriod"`
	Period                            string           `position:"Query" name:"Period"`
	BackupLogIntervalSeconds          requests.Integer `position:"Query" name:"BackupLogIntervalSeconds"`
	FromApp                           string           `position:"Query" name:"FromApp"`
	SourceEndpointPassword            string           `position:"Query" name:"SourceEndpointPassword"`
	OwnerId                           string           `position:"Query" name:"OwnerId"`
	BackupMethod                      string           `position:"Query" name:"BackupMethod"`
	BackupRetentionPeriod             requests.Integer `position:"Query" name:"BackupRetentionPeriod"`
	BackupPeriod                      string           `position:"Query" name:"BackupPeriod"`
	BackupSpeedLimit                  requests.Integer `position:"Query" name:"BackupSpeedLimit"`
	SourceEndpointInstanceType        string           `position:"Query" name:"SourceEndpointInstanceType"`
	BackupPlanName                    string           `position:"Query" name:"BackupPlanName"`
	OSSBucketName                     string           `position:"Query" name:"OSSBucketName"`
	Region                            string           `position:"Query" name:"Region"`
	SourceEndpointRegion              string           `position:"Query" name:"SourceEndpointRegion"`
	SourceEndpointInstanceID          string           `position:"Query" name:"SourceEndpointInstanceID"`
	ClientToken                       string           `position:"Query" name:"ClientToken"`
	BackupPlanId                      string           `position:"Query" name:"BackupPlanId"`
	InstanceClass                     string           `position:"Query" name:"InstanceClass"`
	SourceEndpointDatabaseName        string           `position:"Query" name:"SourceEndpointDatabaseName"`
	DuplicationInfrequentAccessPeriod requests.Integer `position:"Query" name:"DuplicationInfrequentAccessPeriod"`
	InstanceType                      string           `position:"Query" name:"InstanceType"`
	EnableBackupLog                   requests.Boolean `position:"Query" name:"EnableBackupLog"`
	CrossAliyunId                     string           `position:"Query" name:"CrossAliyunId"`
	BackupObjects                     string           `position:"Query" name:"BackupObjects"`
	BackupRateLimit                   requests.Integer `position:"Query" name:"BackupRateLimit"`
	UsedTime                          requests.Integer `position:"Query" name:"UsedTime"`
	SourceEndpointPort                requests.Integer `position:"Query" name:"SourceEndpointPort"`
	StorageRegion                     string           `position:"Query" name:"StorageRegion"`
	SourceEndpointOracleSID           string           `position:"Query" name:"SourceEndpointOracleSID"`
	BackupStrategyType                string           `position:"Query" name:"BackupStrategyType"`
	PayType                           string           `position:"Query" name:"PayType"`
}

// CreateAndStartBackupPlanResponse is the response struct for api CreateAndStartBackupPlan
type CreateAndStartBackupPlanResponse struct {
	*responses.BaseResponse
	HttpStatusCode  int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId       string `json:"RequestId" xml:"RequestId"`
	CreateBackupSet bool   `json:"CreateBackupSet" xml:"CreateBackupSet"`
	ErrCode         string `json:"ErrCode" xml:"ErrCode"`
	Success         bool   `json:"Success" xml:"Success"`
	ErrMessage      string `json:"ErrMessage" xml:"ErrMessage"`
	BackupPlanId    string `json:"BackupPlanId" xml:"BackupPlanId"`
	OrderId         string `json:"OrderId" xml:"OrderId"`
}

// CreateCreateAndStartBackupPlanRequest creates a request to invoke CreateAndStartBackupPlan API
func CreateCreateAndStartBackupPlanRequest() (request *CreateAndStartBackupPlanRequest) {
	request = &CreateAndStartBackupPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dbs", "2019-03-06", "CreateAndStartBackupPlan", "cbs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateAndStartBackupPlanResponse creates a response to parse from CreateAndStartBackupPlan response
func CreateCreateAndStartBackupPlanResponse() (response *CreateAndStartBackupPlanResponse) {
	response = &CreateAndStartBackupPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
