package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchDeleteDcdnKv invokes the dcdn.BatchDeleteDcdnKv API synchronously
func (client *Client) BatchDeleteDcdnKv(request *BatchDeleteDcdnKvRequest) (response *BatchDeleteDcdnKvResponse, err error) {
	response = CreateBatchDeleteDcdnKvResponse()
	err = client.DoAction(request, response)
	return
}

// BatchDeleteDcdnKvWithChan invokes the dcdn.BatchDeleteDcdnKv API asynchronously
func (client *Client) BatchDeleteDcdnKvWithChan(request *BatchDeleteDcdnKvRequest) (<-chan *BatchDeleteDcdnKvResponse, <-chan error) {
	responseChan := make(chan *BatchDeleteDcdnKvResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchDeleteDcdnKv(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchDeleteDcdnKvWithCallback invokes the dcdn.BatchDeleteDcdnKv API asynchronously
func (client *Client) BatchDeleteDcdnKvWithCallback(request *BatchDeleteDcdnKvRequest, callback func(response *BatchDeleteDcdnKvResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchDeleteDcdnKvResponse
		var err error
		defer close(result)
		response, err = client.BatchDeleteDcdnKv(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchDeleteDcdnKvRequest is the request struct for api BatchDeleteDcdnKv
type BatchDeleteDcdnKvRequest struct {
	*requests.RpcRequest
	Keys      *[]string `position:"Body" name:"Keys"  type:"Json"`
	Namespace string    `position:"Query" name:"Namespace"`
}

// BatchDeleteDcdnKvResponse is the response struct for api BatchDeleteDcdnKv
type BatchDeleteDcdnKvResponse struct {
	*responses.BaseResponse
	RequestId   string   `json:"RequestId" xml:"RequestId"`
	FailKeys    []string `json:"FailKeys" xml:"FailKeys"`
	SuccessKeys []string `json:"SuccessKeys" xml:"SuccessKeys"`
}

// CreateBatchDeleteDcdnKvRequest creates a request to invoke BatchDeleteDcdnKv API
func CreateBatchDeleteDcdnKvRequest() (request *BatchDeleteDcdnKvRequest) {
	request = &BatchDeleteDcdnKvRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "BatchDeleteDcdnKv", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchDeleteDcdnKvResponse creates a response to parse from BatchDeleteDcdnKv response
func CreateBatchDeleteDcdnKvResponse() (response *BatchDeleteDcdnKvResponse) {
	response = &BatchDeleteDcdnKvResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
