package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchDeleteDcdnWafRules invokes the dcdn.BatchDeleteDcdnWafRules API synchronously
func (client *Client) BatchDeleteDcdnWafRules(request *BatchDeleteDcdnWafRulesRequest) (response *BatchDeleteDcdnWafRulesResponse, err error) {
	response = CreateBatchDeleteDcdnWafRulesResponse()
	err = client.DoAction(request, response)
	return
}

// BatchDeleteDcdnWafRulesWithChan invokes the dcdn.BatchDeleteDcdnWafRules API asynchronously
func (client *Client) BatchDeleteDcdnWafRulesWithChan(request *BatchDeleteDcdnWafRulesRequest) (<-chan *BatchDeleteDcdnWafRulesResponse, <-chan error) {
	responseChan := make(chan *BatchDeleteDcdnWafRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchDeleteDcdnWafRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchDeleteDcdnWafRulesWithCallback invokes the dcdn.BatchDeleteDcdnWafRules API asynchronously
func (client *Client) BatchDeleteDcdnWafRulesWithCallback(request *BatchDeleteDcdnWafRulesRequest, callback func(response *BatchDeleteDcdnWafRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchDeleteDcdnWafRulesResponse
		var err error
		defer close(result)
		response, err = client.BatchDeleteDcdnWafRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchDeleteDcdnWafRulesRequest is the request struct for api BatchDeleteDcdnWafRules
type BatchDeleteDcdnWafRulesRequest struct {
	*requests.RpcRequest
	RuleIds string `position:"Body" name:"RuleIds"`
}

// BatchDeleteDcdnWafRulesResponse is the response struct for api BatchDeleteDcdnWafRules
type BatchDeleteDcdnWafRulesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchDeleteDcdnWafRulesRequest creates a request to invoke BatchDeleteDcdnWafRules API
func CreateBatchDeleteDcdnWafRulesRequest() (request *BatchDeleteDcdnWafRulesRequest) {
	request = &BatchDeleteDcdnWafRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "BatchDeleteDcdnWafRules", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchDeleteDcdnWafRulesResponse creates a response to parse from BatchDeleteDcdnWafRules response
func CreateBatchDeleteDcdnWafRulesResponse() (response *BatchDeleteDcdnWafRulesResponse) {
	response = &BatchDeleteDcdnWafRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
