package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnWafDomains invokes the dcdn.DescribeDcdnWafDomains API synchronously
func (client *Client) DescribeDcdnWafDomains(request *DescribeDcdnWafDomainsRequest) (response *DescribeDcdnWafDomainsResponse, err error) {
	response = CreateDescribeDcdnWafDomainsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnWafDomainsWithChan invokes the dcdn.DescribeDcdnWafDomains API asynchronously
func (client *Client) DescribeDcdnWafDomainsWithChan(request *DescribeDcdnWafDomainsRequest) (<-chan *DescribeDcdnWafDomainsResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnWafDomainsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnWafDomains(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnWafDomainsWithCallback invokes the dcdn.DescribeDcdnWafDomains API asynchronously
func (client *Client) DescribeDcdnWafDomainsWithCallback(request *DescribeDcdnWafDomainsRequest, callback func(response *DescribeDcdnWafDomainsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnWafDomainsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnWafDomains(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnWafDomainsRequest is the request struct for api DescribeDcdnWafDomains
type DescribeDcdnWafDomainsRequest struct {
	*requests.RpcRequest
	QueryArgs  string           `position:"Query" name:"QueryArgs"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeDcdnWafDomainsResponse is the response struct for api DescribeDcdnWafDomains
type DescribeDcdnWafDomainsResponse struct {
	*responses.BaseResponse
	PageSize   int          `json:"PageSize" xml:"PageSize"`
	RequestId  string       `json:"RequestId" xml:"RequestId"`
	PageNumber int          `json:"PageNumber" xml:"PageNumber"`
	TotalCount int          `json:"TotalCount" xml:"TotalCount"`
	Domains    []DomainItem `json:"Domains" xml:"Domains"`
}

// CreateDescribeDcdnWafDomainsRequest creates a request to invoke DescribeDcdnWafDomains API
func CreateDescribeDcdnWafDomainsRequest() (request *DescribeDcdnWafDomainsRequest) {
	request = &DescribeDcdnWafDomainsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnWafDomains", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnWafDomainsResponse creates a response to parse from DescribeDcdnWafDomains response
func CreateDescribeDcdnWafDomainsResponse() (response *DescribeDcdnWafDomainsResponse) {
	response = &DescribeDcdnWafDomainsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
