package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnWafService invokes the dcdn.DescribeDcdnWafService API synchronously
func (client *Client) DescribeDcdnWafService(request *DescribeDcdnWafServiceRequest) (response *DescribeDcdnWafServiceResponse, err error) {
	response = CreateDescribeDcdnWafServiceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnWafServiceWithChan invokes the dcdn.DescribeDcdnWafService API asynchronously
func (client *Client) DescribeDcdnWafServiceWithChan(request *DescribeDcdnWafServiceRequest) (<-chan *DescribeDcdnWafServiceResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnWafServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnWafService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnWafServiceWithCallback invokes the dcdn.DescribeDcdnWafService API asynchronously
func (client *Client) DescribeDcdnWafServiceWithCallback(request *DescribeDcdnWafServiceRequest, callback func(response *DescribeDcdnWafServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnWafServiceResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnWafService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnWafServiceRequest is the request struct for api DescribeDcdnWafService
type DescribeDcdnWafServiceRequest struct {
	*requests.RpcRequest
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// DescribeDcdnWafServiceResponse is the response struct for api DescribeDcdnWafService
type DescribeDcdnWafServiceResponse struct {
	*responses.BaseResponse
	Status             string `json:"Status" xml:"Status"`
	RequestBillingType string `json:"RequestBillingType" xml:"RequestBillingType"`
	Edition            string `json:"Edition" xml:"Edition"`
	RequestId          string `json:"RequestId" xml:"RequestId"`
	OpeningTime        string `json:"OpeningTime" xml:"OpeningTime"`
	Enabled            string `json:"Enabled" xml:"Enabled"`
	RuleBillingType    string `json:"RuleBillingType" xml:"RuleBillingType"`
}

// CreateDescribeDcdnWafServiceRequest creates a request to invoke DescribeDcdnWafService API
func CreateDescribeDcdnWafServiceRequest() (request *DescribeDcdnWafServiceRequest) {
	request = &DescribeDcdnWafServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnWafService", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnWafServiceResponse creates a response to parse from DescribeDcdnWafService response
func CreateDescribeDcdnWafServiceResponse() (response *DescribeDcdnWafServiceResponse) {
	response = &DescribeDcdnWafServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
