package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefreshDcdnObjectCacheByCacheTag invokes the dcdn.RefreshDcdnObjectCacheByCacheTag API synchronously
func (client *Client) RefreshDcdnObjectCacheByCacheTag(request *RefreshDcdnObjectCacheByCacheTagRequest) (response *RefreshDcdnObjectCacheByCacheTagResponse, err error) {
	response = CreateRefreshDcdnObjectCacheByCacheTagResponse()
	err = client.DoAction(request, response)
	return
}

// RefreshDcdnObjectCacheByCacheTagWithChan invokes the dcdn.RefreshDcdnObjectCacheByCacheTag API asynchronously
func (client *Client) RefreshDcdnObjectCacheByCacheTagWithChan(request *RefreshDcdnObjectCacheByCacheTagRequest) (<-chan *RefreshDcdnObjectCacheByCacheTagResponse, <-chan error) {
	responseChan := make(chan *RefreshDcdnObjectCacheByCacheTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefreshDcdnObjectCacheByCacheTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefreshDcdnObjectCacheByCacheTagWithCallback invokes the dcdn.RefreshDcdnObjectCacheByCacheTag API asynchronously
func (client *Client) RefreshDcdnObjectCacheByCacheTagWithCallback(request *RefreshDcdnObjectCacheByCacheTagRequest, callback func(response *RefreshDcdnObjectCacheByCacheTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefreshDcdnObjectCacheByCacheTagResponse
		var err error
		defer close(result)
		response, err = client.RefreshDcdnObjectCacheByCacheTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefreshDcdnObjectCacheByCacheTagRequest is the request struct for api RefreshDcdnObjectCacheByCacheTag
type RefreshDcdnObjectCacheByCacheTagRequest struct {
	*requests.RpcRequest
	CacheTag   string           `position:"Query" name:"CacheTag"`
	DomainName string           `position:"Query" name:"DomainName"`
	Force      requests.Boolean `position:"Query" name:"Force"`
}

// RefreshDcdnObjectCacheByCacheTagResponse is the response struct for api RefreshDcdnObjectCacheByCacheTag
type RefreshDcdnObjectCacheByCacheTagResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	RefreshTaskId string `json:"RefreshTaskId" xml:"RefreshTaskId"`
}

// CreateRefreshDcdnObjectCacheByCacheTagRequest creates a request to invoke RefreshDcdnObjectCacheByCacheTag API
func CreateRefreshDcdnObjectCacheByCacheTagRequest() (request *RefreshDcdnObjectCacheByCacheTagRequest) {
	request = &RefreshDcdnObjectCacheByCacheTagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "RefreshDcdnObjectCacheByCacheTag", "", "")
	request.Method = requests.POST
	return
}

// CreateRefreshDcdnObjectCacheByCacheTagResponse creates a response to parse from RefreshDcdnObjectCacheByCacheTag response
func CreateRefreshDcdnObjectCacheByCacheTagResponse() (response *RefreshDcdnObjectCacheByCacheTagResponse) {
	response = &RefreshDcdnObjectCacheByCacheTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
