package ddosbgp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSchedruleOnDemand invokes the ddosbgp.DeleteSchedruleOnDemand API synchronously
func (client *Client) DeleteSchedruleOnDemand(request *DeleteSchedruleOnDemandRequest) (response *DeleteSchedruleOnDemandResponse, err error) {
	response = CreateDeleteSchedruleOnDemandResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSchedruleOnDemandWithChan invokes the ddosbgp.DeleteSchedruleOnDemand API asynchronously
func (client *Client) DeleteSchedruleOnDemandWithChan(request *DeleteSchedruleOnDemandRequest) (<-chan *DeleteSchedruleOnDemandResponse, <-chan error) {
	responseChan := make(chan *DeleteSchedruleOnDemandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSchedruleOnDemand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSchedruleOnDemandWithCallback invokes the ddosbgp.DeleteSchedruleOnDemand API asynchronously
func (client *Client) DeleteSchedruleOnDemandWithCallback(request *DeleteSchedruleOnDemandRequest, callback func(response *DeleteSchedruleOnDemandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSchedruleOnDemandResponse
		var err error
		defer close(result)
		response, err = client.DeleteSchedruleOnDemand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSchedruleOnDemandRequest is the request struct for api DeleteSchedruleOnDemand
type DeleteSchedruleOnDemandRequest struct {
	*requests.RpcRequest
	RuleName   string `position:"Query" name:"RuleName"`
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
}

// DeleteSchedruleOnDemandResponse is the response struct for api DeleteSchedruleOnDemand
type DeleteSchedruleOnDemandResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteSchedruleOnDemandRequest creates a request to invoke DeleteSchedruleOnDemand API
func CreateDeleteSchedruleOnDemandRequest() (request *DeleteSchedruleOnDemandRequest) {
	request = &DeleteSchedruleOnDemandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddosbgp", "2018-07-20", "DeleteSchedruleOnDemand", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteSchedruleOnDemandResponse creates a response to parse from DeleteSchedruleOnDemand response
func CreateDeleteSchedruleOnDemandResponse() (response *DeleteSchedruleOnDemandResponse) {
	response = &DeleteSchedruleOnDemandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
