package ddosbgp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSlsOpenStatus invokes the ddosbgp.GetSlsOpenStatus API synchronously
func (client *Client) GetSlsOpenStatus(request *GetSlsOpenStatusRequest) (response *GetSlsOpenStatusResponse, err error) {
	response = CreateGetSlsOpenStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetSlsOpenStatusWithChan invokes the ddosbgp.GetSlsOpenStatus API asynchronously
func (client *Client) GetSlsOpenStatusWithChan(request *GetSlsOpenStatusRequest) (<-chan *GetSlsOpenStatusResponse, <-chan error) {
	responseChan := make(chan *GetSlsOpenStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSlsOpenStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSlsOpenStatusWithCallback invokes the ddosbgp.GetSlsOpenStatus API asynchronously
func (client *Client) GetSlsOpenStatusWithCallback(request *GetSlsOpenStatusRequest, callback func(response *GetSlsOpenStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSlsOpenStatusResponse
		var err error
		defer close(result)
		response, err = client.GetSlsOpenStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSlsOpenStatusRequest is the request struct for api GetSlsOpenStatus
type GetSlsOpenStatusRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
}

// GetSlsOpenStatusResponse is the response struct for api GetSlsOpenStatus
type GetSlsOpenStatusResponse struct {
	*responses.BaseResponse
	SlsOpenStatus bool   `json:"SlsOpenStatus" xml:"SlsOpenStatus"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateGetSlsOpenStatusRequest creates a request to invoke GetSlsOpenStatus API
func CreateGetSlsOpenStatusRequest() (request *GetSlsOpenStatusRequest) {
	request = &GetSlsOpenStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddosbgp", "2018-07-20", "GetSlsOpenStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateGetSlsOpenStatusResponse creates a response to parse from GetSlsOpenStatus response
func CreateGetSlsOpenStatusResponse() (response *GetSlsOpenStatusResponse) {
	response = &GetSlsOpenStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
