package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSchedulerRule invokes the ddoscoo.DeleteSchedulerRule API synchronously
func (client *Client) DeleteSchedulerRule(request *DeleteSchedulerRuleRequest) (response *DeleteSchedulerRuleResponse, err error) {
	response = CreateDeleteSchedulerRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSchedulerRuleWithChan invokes the ddoscoo.DeleteSchedulerRule API asynchronously
func (client *Client) DeleteSchedulerRuleWithChan(request *DeleteSchedulerRuleRequest) (<-chan *DeleteSchedulerRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteSchedulerRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSchedulerRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSchedulerRuleWithCallback invokes the ddoscoo.DeleteSchedulerRule API asynchronously
func (client *Client) DeleteSchedulerRuleWithCallback(request *DeleteSchedulerRuleRequest, callback func(response *DeleteSchedulerRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSchedulerRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteSchedulerRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSchedulerRuleRequest is the request struct for api DeleteSchedulerRule
type DeleteSchedulerRuleRequest struct {
	*requests.RpcRequest
	RuleName        string `position:"Query" name:"RuleName"`
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
}

// DeleteSchedulerRuleResponse is the response struct for api DeleteSchedulerRule
type DeleteSchedulerRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteSchedulerRuleRequest creates a request to invoke DeleteSchedulerRule API
func CreateDeleteSchedulerRuleRequest() (request *DeleteSchedulerRuleRequest) {
	request = &DeleteSchedulerRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DeleteSchedulerRule", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSchedulerRuleResponse creates a response to parse from DeleteSchedulerRule response
func CreateDeleteSchedulerRuleResponse() (response *DeleteSchedulerRuleResponse) {
	response = &DeleteSchedulerRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
