package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAuditPolicy invokes the dds.DescribeAuditPolicy API synchronously
func (client *Client) DescribeAuditPolicy(request *DescribeAuditPolicyRequest) (response *DescribeAuditPolicyResponse, err error) {
	response = CreateDescribeAuditPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAuditPolicyWithChan invokes the dds.DescribeAuditPolicy API asynchronously
func (client *Client) DescribeAuditPolicyWithChan(request *DescribeAuditPolicyRequest) (<-chan *DescribeAuditPolicyResponse, <-chan error) {
	responseChan := make(chan *DescribeAuditPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAuditPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAuditPolicyWithCallback invokes the dds.DescribeAuditPolicy API asynchronously
func (client *Client) DescribeAuditPolicyWithCallback(request *DescribeAuditPolicyRequest, callback func(response *DescribeAuditPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAuditPolicyResponse
		var err error
		defer close(result)
		response, err = client.DescribeAuditPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAuditPolicyRequest is the request struct for api DescribeAuditPolicy
type DescribeAuditPolicyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeAuditPolicyResponse is the response struct for api DescribeAuditPolicy
type DescribeAuditPolicyResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	LogAuditStatus string `json:"LogAuditStatus" xml:"LogAuditStatus"`
}

// CreateDescribeAuditPolicyRequest creates a request to invoke DescribeAuditPolicy API
func CreateDescribeAuditPolicyRequest() (request *DescribeAuditPolicyRequest) {
	request = &DescribeAuditPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "DescribeAuditPolicy", "dds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAuditPolicyResponse creates a response to parse from DescribeAuditPolicy response
func CreateDescribeAuditPolicyResponse() (response *DescribeAuditPolicyResponse) {
	response = &DescribeAuditPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
