package dfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVscMountPoints invokes the dfs.DescribeVscMountPoints API synchronously
func (client *Client) DescribeVscMountPoints(request *DescribeVscMountPointsRequest) (response *DescribeVscMountPointsResponse, err error) {
	response = CreateDescribeVscMountPointsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVscMountPointsWithChan invokes the dfs.DescribeVscMountPoints API asynchronously
func (client *Client) DescribeVscMountPointsWithChan(request *DescribeVscMountPointsRequest) (<-chan *DescribeVscMountPointsResponse, <-chan error) {
	responseChan := make(chan *DescribeVscMountPointsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVscMountPoints(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVscMountPointsWithCallback invokes the dfs.DescribeVscMountPoints API asynchronously
func (client *Client) DescribeVscMountPointsWithCallback(request *DescribeVscMountPointsRequest, callback func(response *DescribeVscMountPointsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVscMountPointsResponse
		var err error
		defer close(result)
		response, err = client.DescribeVscMountPoints(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVscMountPointsRequest is the request struct for api DescribeVscMountPoints
type DescribeVscMountPointsRequest struct {
	*requests.RpcRequest
	VscId         string `position:"Query" name:"VscId"`
	InputRegionId string `position:"Query" name:"InputRegionId"`
	MountPointId  string `position:"Query" name:"MountPointId"`
	FileSystemId  string `position:"Query" name:"FileSystemId"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	Status        string `position:"Query" name:"Status"`
}

// DescribeVscMountPointsResponse is the response struct for api DescribeVscMountPoints
type DescribeVscMountPointsResponse struct {
	*responses.BaseResponse
	TotalCount  int          `json:"TotalCount" xml:"TotalCount"`
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	MountPoints []MountPoint `json:"MountPoints" xml:"MountPoints"`
}

// CreateDescribeVscMountPointsRequest creates a request to invoke DescribeVscMountPoints API
func CreateDescribeVscMountPointsRequest() (request *DescribeVscMountPointsRequest) {
	request = &DescribeVscMountPointsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DFS", "2018-06-20", "DescribeVscMountPoints", "alidfs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVscMountPointsResponse creates a response to parse from DescribeVscMountPoints response
func CreateDescribeVscMountPointsResponse() (response *DescribeVscMountPointsResponse) {
	response = &DescribeVscMountPointsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
