package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAbacPolicy invokes the dms_enterprise.GetAbacPolicy API synchronously
func (client *Client) GetAbacPolicy(request *GetAbacPolicyRequest) (response *GetAbacPolicyResponse, err error) {
	response = CreateGetAbacPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// GetAbacPolicyWithChan invokes the dms_enterprise.GetAbacPolicy API asynchronously
func (client *Client) GetAbacPolicyWithChan(request *GetAbacPolicyRequest) (<-chan *GetAbacPolicyResponse, <-chan error) {
	responseChan := make(chan *GetAbacPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAbacPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAbacPolicyWithCallback invokes the dms_enterprise.GetAbacPolicy API asynchronously
func (client *Client) GetAbacPolicyWithCallback(request *GetAbacPolicyRequest, callback func(response *GetAbacPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAbacPolicyResponse
		var err error
		defer close(result)
		response, err = client.GetAbacPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAbacPolicyRequest is the request struct for api GetAbacPolicy
type GetAbacPolicyRequest struct {
	*requests.RpcRequest
	Tid            requests.Integer `position:"Query" name:"Tid"`
	AbacPolicyId   requests.Integer `position:"Query" name:"AbacPolicyId"`
	AbacPolicyName string           `position:"Query" name:"AbacPolicyName"`
}

// GetAbacPolicyResponse is the response struct for api GetAbacPolicy
type GetAbacPolicyResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Policy       Policy `json:"Policy" xml:"Policy"`
}

// CreateGetAbacPolicyRequest creates a request to invoke GetAbacPolicy API
func CreateGetAbacPolicyRequest() (request *GetAbacPolicyRequest) {
	request = &GetAbacPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetAbacPolicy", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAbacPolicyResponse creates a response to parse from GetAbacPolicy response
func CreateGetAbacPolicyResponse() (response *GetAbacPolicyResponse) {
	response = &GetAbacPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
