package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetStructSyncOrderDetail invokes the dms_enterprise.GetStructSyncOrderDetail API synchronously
func (client *Client) GetStructSyncOrderDetail(request *GetStructSyncOrderDetailRequest) (response *GetStructSyncOrderDetailResponse, err error) {
	response = CreateGetStructSyncOrderDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetStructSyncOrderDetailWithChan invokes the dms_enterprise.GetStructSyncOrderDetail API asynchronously
func (client *Client) GetStructSyncOrderDetailWithChan(request *GetStructSyncOrderDetailRequest) (<-chan *GetStructSyncOrderDetailResponse, <-chan error) {
	responseChan := make(chan *GetStructSyncOrderDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetStructSyncOrderDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetStructSyncOrderDetailWithCallback invokes the dms_enterprise.GetStructSyncOrderDetail API asynchronously
func (client *Client) GetStructSyncOrderDetailWithCallback(request *GetStructSyncOrderDetailRequest, callback func(response *GetStructSyncOrderDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetStructSyncOrderDetailResponse
		var err error
		defer close(result)
		response, err = client.GetStructSyncOrderDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetStructSyncOrderDetailRequest is the request struct for api GetStructSyncOrderDetail
type GetStructSyncOrderDetailRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	OrderId requests.Integer `position:"Query" name:"OrderId"`
}

// GetStructSyncOrderDetailResponse is the response struct for api GetStructSyncOrderDetail
type GetStructSyncOrderDetailResponse struct {
	*responses.BaseResponse
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	Success               bool                  `json:"Success" xml:"Success"`
	ErrorMessage          string                `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode             string                `json:"ErrorCode" xml:"ErrorCode"`
	StructSyncOrderDetail StructSyncOrderDetail `json:"StructSyncOrderDetail" xml:"StructSyncOrderDetail"`
}

// CreateGetStructSyncOrderDetailRequest creates a request to invoke GetStructSyncOrderDetail API
func CreateGetStructSyncOrderDetailRequest() (request *GetStructSyncOrderDetailRequest) {
	request = &GetStructSyncOrderDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetStructSyncOrderDetail", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetStructSyncOrderDetailResponse creates a response to parse from GetStructSyncOrderDetail response
func CreateGetStructSyncOrderDetailResponse() (response *GetStructSyncOrderDetailResponse) {
	response = &GetStructSyncOrderDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
